#ifndef MARS_MCalibrationConfig
#define MARS_MCalibrationConfig

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MCalibrationConfig                                                      //
//                                                                         //
// Contains all configuration data of the Calibration                      //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////


// The highest value of the High Gain in the linear regime
const Byte_t gkSaturationLimit = 250;

// The conversion factor between High Gain and Low Gain
const UShort_t gkConversionHiLo = 10.;

// The penalty constant to produce overflow in the histogram 
const ULong_t gkLoGainOverFlow = 99999999;

// ----- BLIND PIXEL ----------------------//

// Pixel ID of the Calibration Blind Pixel
const UShort_t gkCalibrationBlindPixelId = 559;

// Average QE of Blind Pixel (three colours)
const Float_t gkCalibrationBlindPixelQEGreen = 0.154;
const Float_t gkCalibrationBlindPixelQEBlue  = 0.226;
const Float_t gkCalibrationBlindPixelQEUV    = 0.247;

// Attenuation factor Blind Pixel (three colours)
const Float_t gkCalibrationBlindPixelAttGreen = 1.97;
const Float_t gkCalibrationBlindPixelAttBlue  = 1.96;
const Float_t gkCalibrationBlindPixelAttUV    = 1.95;

// Area of Blind Pixel w.r.t. Inner Pixel
const Float_t gkCalibrationBlindPixelArea     = 0.25;

// ----- PIN DIODE ------------------------//

// Pixel ID of the Calibration PIN Diode
const UShort_t gkCalibrationPINDiodeId = 9999;

#endif /* MARS_MCalibrationBlindPixelConfig */
