/********************************************************************\

  Read SOCKETS_PER_FAD Channels from FAD-Board
  Write Commands to Socket 0, Commands must be (n * 16) Bit long
  
  Usage: SocketClient [IP-Address]
  
  kw, 05.10
  
  based on:
  Generic example for remote control via a socket interface

  Oliver Grimm, March 2009

\********************************************************************/
#ifndef PATH_MAX
#define PATH_MAX 1000
#endif
#include "simple_daq.h"
#include "../SocketFunctions/SocketFunctions.h"


int *SocketDescriptor;

int main(int argc, char *argv[])
{
	// what kind of buffer is this?
	char Buffer[MAX_COM_SIZE];
	
	int read_return;

	fd_set ReadFileDescriptor;
	int max_fd = 0;
	
	FILE* outfile[SOCKETS_PER_FAD];
	char outfilename[PATH_MAX];

	
		SimpleDaqConfiguration *conf;
	// Get configuration file path from command line
	// Get configurarion from configurationfile.
	// such as FAD IP Adress
	if (argc > 1)
	{
		conf = getConfig(argv[1]);
	} else {
		conf = getConfig(CONFIG_FILE_PATH);
	}
	
	// Open sockets
	SocketDescriptor = OpenSockets(SOCKETS_PER_FAD);
	if (SocketDescriptor == NULL) {
		exit_program (EXIT_FAILURE);
	}
	max_fd = GetMaxFileDescriptor(SOCKETS_PER_FAD, SocketDescriptor);
	
	// Connect to server
	if( Connect2Server(	SocketDescriptor, SOCKETS_PER_FAD, FIRST_DAQPORT, conf->FADIPAddress, 1) != SOCKETS_PER_FAD) {
			// Connect2Server prints some error messages in case of exceptions...
			printf ("Error in Connect2Server()\n");
			exit_program (EXIT_FAILURE);
	}

	// Open files for output
	for (int i = 0; i < SOCKETS_PER_FAD; i++)
	{
		sprintf (outfilename, "%s/%s-%d.%s", conf->outfilepath, conf->outfilename, i, conf->outfileext);
		if ((outfile[i] = fopen (outfilename, "w")) == NULL)
		{
			printf ("Error: Could not open file %s\n", outfilename);
			exit_program (EXIT_FAILURE);
		}
	}


	signal (SIGPIPE, SIG_IGN); // Do not kill process if writing to closed socket
	signal (SIGINT, int_handler); // Cleanup after SIGINT (CTRL-C)

	// Main loop
	while (true)
	{
		fflush (stdout);

		FD_ZERO (&ReadFileDescriptor);		
		FD_SET(STDIN_FILENO, &ReadFileDescriptor);
		for (int i = 0; i < SOCKETS_PER_FAD; i++)
		{
			FD_SET (SocketDescriptor[i], &ReadFileDescriptor);
		}

		// Wait for data from sockets
		if (select (((int) max_fd) + 1, &ReadFileDescriptor, NULL, NULL, NULL) == -1)
		{
			perror ("Error with select()\n");
			break;
		}
		
		memset (Buffer, 0, sizeof (Buffer));

		// Data from STDIN
		if (FD_ISSET (STDIN_FILENO, &ReadFileDescriptor))
		{
			fgets (Buffer, MAX_COM_SIZE, stdin);
			// Send command to socket 0
			cmd_send (Buffer, SocketDescriptor[0]);			
		}
		// Data from sockets
		else
		{
			// Check all sockets
			for (int i = 0; i < SOCKETS_PER_FAD; i++)
			{
				if (FD_ISSET (SocketDescriptor[i], &ReadFileDescriptor))
				{ 
					// Only for testing
					memset (Buffer, 0xAA, sizeof (Buffer));
					if ((read_return = read (SocketDescriptor[i], Buffer, MAX_COM_SIZE)) == 0)
					{
						printf ("Error: Server not existing anymore, exiting...\n");
						exit_program (EXIT_FAILURE);
					}
	
					if (read_return > 0)
					{
						printf ("Socket [%d]: Read %d Bytes\n", i, read_return);
					
						fwrite (Buffer, 1, (size_t) read_return, outfile[i]);
						// Important!!!
						fflush (outfile[i]);
					}
				}
			}
		}
	} // while (TRUE)

	exit (EXIT_SUCCESS);
}

// close sockets and exit
void exit_program (int exit_status)
{	
	printf ("\nClosing Sockets...");
	for (int i = 0; i < SOCKETS_PER_FAD; i++)
	{
		close (SocketDescriptor[i]);
	}
	printf (" done\n");
	
	exit (exit_status);
}

// SIGINT
void int_handler (int sig)
{
	exit_program (EXIT_SUCCESS);
}


// note: verbose is not used, but anyway defined.
SimpleDaqConfiguration *getConfig (const char *path, int verbose) {
FILE* ConfigFile;
// try to open config file
// if not exists return NULL
ConfigFile = fopen (path, "r");
if (ConfigFile == NULL) {
	return NULL;
}

//create SimpleDaqConfiguration
SimpleDaqConfiguration *conf = new SimpleDaqConfiguration();

// read config data from file and fill in SimpleDaqConfiguration
fscanf( ConfigFile , "%s" , conf->FADIPAddress );
fscanf( ConfigFile , "%s" , conf->outfilepath );
fscanf( ConfigFile , "%s" , conf->outfilename );
fscanf( ConfigFile , "%s" , conf->outfileext );

return conf;
}
