/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Markus Gaug   11/2003 <mailto:markus@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MCalibrationPINDiode                                                            //
//                                                                         //
// This is the storage container to hold informations about the pedestal   //
// (offset) value of one Pixel (PMT).                                      //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
#include "MCalibrationPINDiode.h"

#include "MLog.h"

ClassImp(MCalibrationPINDiode);

using namespace std;
// --------------------------------------------------------------------------
//
// Default Constructor. 
//
MCalibrationPINDiode::MCalibrationPINDiode(const char *name, const char *title)
  : fHist(NULL),
    fCharge(-1.),
    fErrCharge(-1.),
    fPed(-1.),
    fPedRms(-1.),
    fSigmaCharge(-1.),
    fErrSigmaCharge(-1.),
    fTime(-1.),
    fErrTime(-1.),
    fRCharge(-1.),
    fErrRCharge(-1.)
{

  fName  = name  ? name  : "MCalibrationPINDiode";
  fTitle = title ? title : "Container of the MHCalibrationPINDiode and the fit results";

  fHist = new MHCalibrationPINDiode();

}

MCalibrationPINDiode::~MCalibrationPINDiode() 
{
  delete fHist;
}

// ------------------------------------------------------------------------
//
// Invalidate values
//
void MCalibrationPINDiode::Clear(Option_t *o)
{
  fHist->Reset();
}

Bool_t MCalibrationPINDiode::FitCharge() 
{
  if(!fHist->FitChargeHiGain())
    return kFALSE;

  fCharge         = fHist->GetChargeMean();
  fErrCharge      = fHist->GetChargeMeanErr(); 
  fSigmaCharge    = fHist->GetChargeSigma();
  fErrSigmaCharge = fHist->GetChargeSigmaErr();

  return kTRUE;
  
}

Bool_t MCalibrationPINDiode::FitTime() 
{

  if(!fHist->FitTimeHiGain())
    return kFALSE;

  fTime    = fHist->GetTime();
  fErrTime = fHist->GetErrTime();
  
  return kTRUE;

}
