#ifndef MARS_MArrivalTimeCalc
#define MARS_MArrivalTimeCalc

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MArrivalTimeCalc                                                        //
//                                                                         //
// Evaluates the number of time slice into which the signal reaches a max. //
// P R E L I M I N A R Y                                                   //
// Other more sophisticated methods have to be implemented.                //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MRawEvtData;
class MCameraData;
class MRawRunHeader;
class MGeomCam;
class MArrivalTime;

class MArrivalTimeCalc : public MTask
{
    MRawEvtData    *fRawEvt;     // raw event data (time slices)
    MCameraData    *fCamData;    // Cerenkov Photon Event used for calculation
    MRawRunHeader  *fRunHeader;  // RunHeader information
    MGeomCam       *fGeom;       // Geometry information
    MArrivalTime   *fArrTime;    // Container with the photons arrival times

    Bool_t          fEnableFix;  // fix for a bug in files from older camera versions (<=40)
    Bool_t          fIsMcFile;

    Int_t PreProcess(MParList *pList);
    Int_t Process();
    Int_t PostProcess() {return kTRUE;}
    Bool_t ReInit(MParList *pList) {
        return kTRUE;
    }

public:
    MArrivalTimeCalc(const char *name=NULL, const char *title=NULL);

    // FIXME: The array size should be checked!

    ~MArrivalTimeCalc(){}

    ClassDef(MArrivalTimeCalc, 0)   // Task to calculate cerenkov photons from raw data
};


#endif
