/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Markus Gaug  12/2003 <mailto:markus@ifae.es>
!   Author(s): Thomas Bretz 12/2003 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MExtractedSignalPix                                                     //
//                                                                         //
// This is the storage container to hold informations about the pedestal   //
// (offset) value of one Pixel (PMT).                                      //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
#include "MExtractedSignalPix.h"
#include "MLog.h"
#include "MLogManip.h"

ClassImp(MExtractedSignalPix);

using namespace std;

MExtractedSignalPix::MExtractedSignalPix(const char* name, const char* title)
  : fExtractedSignalHiGain(-1.),
    fExtractedSignalHiGainError(-1.),
    fExtractedSignalLoGain(-1.),
    fExtractedSignalLoGainError(-1.),
    fIsLoGainUsed(kFALSE),
    fNumHiGainSaturated(0),
    fNumLoGainSaturated(0)
{

  fName  = name  ? name  : "MExtractedSignalPix";
  fTitle = title ? title : "Container of the Extracted Signals";

}



// ------------------------------------------------------------------------
//
// Invalidate values
//
void MExtractedSignalPix::Clear(Option_t *o)
{

  fExtractedSignalHiGain = -1.;
  fExtractedSignalHiGainError = -1.;
  fIsLoGainUsed = kFALSE;
  fNumHiGainSaturated = 0;
  fNumLoGainSaturated = 0;

}

void MExtractedSignalPix::PrintOut()
{

  *fLog << all << GetDescriptor() << ":" << endl;

  *fLog << " Signal: " << fExtractedSignalHiGain
	<< " +- " << fExtractedSignalHiGainError
	<< " LoGain? " << fIsLoGainUsed
 	<< " Nr. Sat. Hi Gain: " <<  fNumHiGainSaturated
	<< " Nr. Sat. Lo Gain: " <<  fNumLoGainSaturated
	<< endl;

}

