#ifndef MARS_MCalibrationPix
#define MARS_MCalibrationPix

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#include "MHCalibrationPixel.h"

class MCalibrationPix : public MParContainer
{
private:

  Int_t   fPixId;           // the pixel Id
  
  Float_t fCharge;              // The mean reduced charge after the fit
  Float_t fErrCharge;           // The error of reduced mean charge after the fit
  Float_t fSigmaCharge;         // The sigma of the mean charge after the fit
  Float_t fErrSigmaCharge;      // The error of the sigma of the mean charge after the fit
  Float_t fRSigmaSquare;        // The reduced squares of sigmas after the fit
  Float_t fChargeProb;          // The probability of the fit function 

  Float_t fPed;                 // The mean pedestal (from MPedestalPix)
  Float_t fPedRms;              // The pedestal  RMS (from MPedestalPix)

  Float_t fTime;                // The mean arrival time after the fit  
  Float_t fSigmaTime;           // The error of the mean arrival time after the fit
  Float_t fTimeProb;            // The probability of the fit function 
  
  Float_t fFactor;                  // The laboratory F-factor
  Float_t fPheFFactorMethod;        // The number of Phe's calculated after the F-factor method
  Float_t fConversionFFactorMethod; // The conversion factor to Phe's calculated after the F-factor method

  Bool_t fHiGainSaturation;     // Is Lo-Gain used at all?

  Float_t fElectronicPedRms;

  MHCalibrationPixel *fHist;    //! Pointer to the histograms performing the fits, etc.  
  
public:

  MCalibrationPix(const char *name=NULL, const char *title=NULL);
  ~MCalibrationPix();
  
  void Clear(Option_t *o="");

  Float_t GetCharge()         const    { return fCharge;         }
  Float_t GetRSigmaSquare()   const    { return fRSigmaSquare;   }
    
  Float_t GetErrCharge()      const    { return fErrCharge;      }
  Float_t GetChargeProb()     const    { return fChargeProb;     }    
  
  Float_t GetSigmaCharge()    const    { return fSigmaCharge;    }
  Float_t GetErrSigmaCharge() const    { return fErrSigmaCharge; }
  Float_t GetTime()           const    { return fTime;         }
  Float_t GetSigmaTime()      const    { return fSigmaTime;    }
  Float_t GetTimeProb()       const    { return fTimeProb;     }    
  
  Float_t GetPed()            const    { return fPed;       }
  Float_t GetPedRms()         const    { return fPedRms;    }    

  void SetPedestal(Float_t ped, Float_t pedrms);
  void SetHiGainSaturation()                 { fHiGainSaturation = kTRUE; fHist->SetUseLoGain(); } 

  void   SetChargesInGraph(Float_t qhi,Float_t qlo) { fHist->SetPointInGraph(qhi,qlo); }

  Bool_t FillChargeHiGain(Float_t q)   { return fHist->FillChargeHiGain(q); }
  Bool_t FillTimeHiGain(Int_t t)       { return fHist->FillTimeHiGain(t); }  
  Bool_t FillRChargevsTimeHiGain(Float_t rq, Int_t t) { return fHist->FillChargevsNHiGain(rq,t); }    

  Bool_t FillChargeLoGain(Float_t q)   { return fHist->FillChargeLoGain(q); }
  Bool_t FillTimeLoGain(Int_t t)       { return fHist->FillTimeLoGain(t); }  
  Bool_t FillRChargevsTimeLoGain(Float_t rq, Int_t t) { return fHist->FillChargevsNLoGain(rq,t); }    
  
  Bool_t IsValid()            const    { return fCharge >=0 || fErrCharge >= 0; }
  Int_t  GetPixId()           const    { return fPixId;   }
  void   DefinePixId(Int_t i);
  
  Bool_t FitCharge();
  Bool_t FitTime();
  
  MHCalibrationPixel *GetHist() const   { return fHist;     }
  void Draw(Option_t *opt="")           { fHist->Draw(opt); }
  
  Float_t GetPheFFactorMethod()           const { return fPheFFactorMethod;           }  
  Float_t GetConversionFFactorMethod()    const { return fConversionFFactorMethod;    }
  
  ClassDef(MCalibrationPix, 1)	// Storage Container for Calibration information of one pixel
};

#endif

