#ifndef MARS_MHEvent
#define MARS_MHEvent

#ifndef MARS_MH
#include "MH.h"
#endif

class MHCamera;
class MRawEvtData;
class MRawRunHeader;
class MRawEvtHeader;

class MMcEvt;
class MCerPhotEvt;
class MPedestalCam;
class MImgCleanStd;
class MCameraSignal;

class MHEvent : public MH
{
public:
    enum EventType_t {
        kEvtSignal, kEvtPedestal, kEvtPedestalRMS,
        kEvtRelativeSignal, kEvtCleaningLevels,
        kEvtArrTime
    };

private:
    MRawEvtData   *fRawEvtData;    //!
    MRawRunHeader *fRawRunHeader;  //!
    MRawEvtHeader *fRawEvtHeader;  //!

    MMcEvt        *fMcEvt;         //!
    MCerPhotEvt   *fCerPhotEvt;    //!
    MPedestalCam  *fPedestalCam;   //!
    MImgCleanStd  *fImgCleanStd;   //!
    MCameraSignal *fCamSignal;     //!

    MRawEvtData   *fClone;         //->

    MHCamera *fHist;

    EventType_t fType;

    TH1 *GetHistByName(const TString name) { return (TH1*)fHist; }

    Bool_t SetupFill(const MParList *plist);
    Bool_t Fill(const MParContainer *par, const Stat_t weight=1);

public:
    MHEvent(EventType_t type=kEvtSignal);
    ~MHEvent();

    MHCamera *GetHist() { return fHist; }

    void Draw(Option_t *o="");
 
    ClassDef(MHEvent, 1)
};

#endif
