--
-- VHDL Architecture FACT_FAD_TB_lib.spi_devices_emulator.beha
--
-- Created:
--          by - Benjamin Krumm.UNKNOWN (EEPC8)
--          at - 09:26:11 28.04.2010
--
-- using Mentor Graphics HDL Designer(TM) 2009.1 (Build 12)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY FACT_FAD_lib;
USE FACT_FAD_lib.fad_definitions.all;

ENTITY max6662_emulator IS
   GENERIC( 
      DRS_TEMPERATURE : integer := 51
   );
   PORT( 
      sclk      : in     std_logic;
      sio       : inout  std_logic;
      sensor_cs : in     std_logic_vector (3 DOWNTO 0)
   );

-- Declarations

END max6662_emulator ;

ARCHITECTURE beha OF max6662_emulator IS

  signal data : std_logic_vector(15 downto 0) := (others => '0');
  signal spi_cycle_cnt : integer := 0;
  signal temperature : integer range -55 to 150 := DRS_TEMPERATURE;
  
BEGIN
  
  spi_cnt_proc: process (sclk)
  begin
    if rising_edge(sclk) then
      if (sensor_cs /= "1111") then
        spi_cycle_cnt <= spi_cycle_cnt + 1;
      else
        spi_cycle_cnt <= 0;
      end if;
    end if;
  end process spi_cnt_proc;
   
  sensor_data_proc: process (spi_cycle_cnt, sclk)
  begin
    if falling_edge(sclk) then
      sio <= 'Z';
      if (spi_cycle_cnt = 1) then
        data <= '0' & conv_std_logic_vector(temperature + conv_integer(sensor_cs), 12) & "000";
      end if;
      if (spi_cycle_cnt > 7) then
        sio <= data(15);
        data(15 downto 1) <= data(14 downto 0);
      end if;
    end if;
  end process sensor_data_proc;
  
END ARCHITECTURE beha;

