#ifndef MARS_MCalibrationConfig
#define MARS_MCalibrationConfig

/////////////////////////////////////////////////////////////////////////////
//                                                                         
// MCalibrationConfig                                                      
//
// Contains all configuration data of the Calibration          
//                                                             
// This file is only TEMPORARY. It values will go into the DATABASE 
//
/////////////////////////////////////////////////////////////////////////////


// The highest value of the High Gain in the linear regime
const Byte_t gkSaturationLimit = 250;

// The conversion factor between High Gain and Low Gain
const Float_t gkConversionHiLo = 10.;

// The penalty constant to produce overflow in the histogram 
const ULong_t gkLoGainOverFlow = 99999999;

// ----- BLIND PIXEL ----------------------//

// Pixel ID of the Calibration Blind Pixel
const UShort_t gkCalibrationBlindPixelId = 559;

// Average QE of Blind Pixel (three colours)
const Float_t gkCalibrationBlindPixelQEGreen = 0.154;
const Float_t gkCalibrationBlindPixelQEBlue  = 0.226;
const Float_t gkCalibrationBlindPixelQEUV    = 0.247;
const Float_t gkCalibrationBlindPixelQECT1   = 0.247;

// Attenuation factor Blind Pixel (three colours)
const Float_t gkCalibrationBlindPixelAttGreen = 1.97;
const Float_t gkCalibrationBlindPixelAttBlue  = 1.96;
const Float_t gkCalibrationBlindPixelAttUV    = 1.95;
const Float_t gkCalibrationBlindPixelAttCT1   = 1.95;

//
// Area of Inner Pixel w.r.t. Blind Pixel (which is 1 cm)
//
// Hexagone of diagonal axis b = 3.5 cm
//             straight axis a = 3.0 cm +- 2% 
// Area =  sqrt(3)*a/2 = 7.79 cm +- 4% = 7.8 +- 0.3 cm
//
const Float_t gkCalibrationInnerPixelArea      = 7.8;
const Float_t gkCalibrationInnerPixelAreaError = 0.3;
//
// Area of Outer Pixel w.r.t. Inner Pixel
//
// Hexagone of diagonal axis b = 7.0 cm
//             straight axis a = 6.0 cm +- 1% 
// Area = sqrt(3)*a/2 = 
//
const Float_t gkCalibrationOutervsInnerPixelArea      = 4.00;
const Float_t gkCalibrationOutervsInnerPixelAreaError = 0.00;

// ----- PIN DIODE ------------------------//

// Pixel ID of the Calibration PIN Diode
const UShort_t gkCalibrationPINDiodeId = 9999;

//
// Area of Inner Pixel w.r.t. PIN Diode (which is 1 cm)
//
// Hexagone of diagonal axis b = 3.5 cm
//             straight axis a = 3.0 cm +- 2% 
// Area =  sqrt(3)*a/2 = 7.79 cm +- 4% = 7.8 +- 0.3 cm
//
// Distance of PIN Diode to pulser D1:   1.5  +- 0.3 m
// Distance of Inner Pixel to pulser D2: 18.0 +- 0.5 m
//
//
//                A(Inner Pixel)    D1
// conversion C = -------------- * ----- = 0.054
//                A(PIN Diode)      D2
//
// Delta C / C  = sqrt((Delta A(IP)/A(IP)) + 4 * ( (Delta D1/D1) + (Delta D2/D2) )
// Delta C / C  = 0.4
// 
// C = 0.05 +- 0.02
//
const Float_t gkCalibrationInnerPixelvsPINDiodeArea      = 0.05;
const Float_t gkCalibrationInnerPixelvsPINDiodeAreaError = 0.02;

// Average QE of the PIN Diode
const Float_t gkCalibrationPINDiodeQEGreen = -1.0;
const Float_t gkCalibrationPINDiodeQEBlue  = -1.0;
const Float_t gkCalibrationPINDiodeQEUV    = -1.0;
const Float_t gkCalibrationPINDiodeQECT1   = -1.0;


#endif /* MARS_MCalibrationConfig */
