#ifndef MARS_MCalibrate
#define MARS_MCalibrate

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MCalibrate                                                            //
//                                                                         //
// Integrates the desired ADC time slices of one pixel and apply           //
// calibration constants                                                   //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
#ifndef ROOT_TArrayF
#include <TArrayF.h>
#endif

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MCalibrationCam;
class MExtractedSignalCam;
class MCerPhotEvt;

class MCalibrate : public MTask
{

  MCalibrationCam     *fCalibrations;
  MExtractedSignalCam *fSignals;
  MCerPhotEvt         *fCerPhotEvt; // Cerenkov Photon Event used for calculation
 
  Int_t PreProcess(MParList *pList);
  Int_t Process();

public:

    MCalibrate(const char *name=NULL, const char *title=NULL);

    ClassDef(MCalibrate, 0)   // Task to calculate cerenkov photons from raw data
};
 

#endif
