#ifndef MARS_MCalibrate
#define MARS_MCalibrate

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MCalibrate                                                              //
//                                                                         //
// Integrates the desired ADC time slices of one pixel and apply           //
// calibration constants                                                   //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
#ifndef ROOT_TArrayF
#include <TArrayF.h>
#endif

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MGeomCam;
class MCalibrationCam;
class MExtractedSignalCam;
class MCerPhotEvt;

class MCalibrate : public MTask
{

    MGeomCam            *fGeomCam;      // Geometry of the camera 
    MCalibrationCam     *fCalibrations; // Calibration constants 
    MExtractedSignalCam *fSignals;      // Integrated charge in FADCs counts
    MCerPhotEvt         *fCerPhotEvt; // Cerenkov Photon Event used for calculation
 
  Int_t PreProcess(MParList *pList);
  Int_t Process();

public:

    MCalibrate(const char *name=NULL, const char *title=NULL);

    ClassDef(MCalibrate, 0)   // Task to calculate cerenkov photons using calibration constants
};
 

#endif
