#ifndef FEEDBACK_H_SEEN
#define FEEDBACK_H_SEEN

#define SERVER_NAME "Feedback"       // Name to use in DIM
#include "Evidence.h"

#define BUF_LENGTH 1000

#include <stdio.h>
#include <readline/readline.h>
#include <readline/history.h>
#include <math.h>
#include <sstream>
#include <vector>

enum FBState {Off, Active, Targets, ResponseFirst, ResponseSecond};

class Feedback: public EvidenceServer {

	struct {
      int State;
	  char Text[BUF_LENGTH];
	} State;

    class PixelMap *PixMap;
    FBState FBMode;
    std::vector<std::string> fIDTable;
	unsigned int *Multiplicity; 

    float *Average;
    float *Sigma;
    float *Response;
    float *Target;
    float *Buffer;
    float *DIMAverage;
    float *DIMSigma;

	DimService *FeedbackAverage;
	DimService *FeedbackSigma;
	DimService *FeedbackResponse;
	DimService *FeedbackTarget;
	DimService *CountService;
	DimService *FeedbackState;
	DimCommand *Command;
	DimService *ConsoleOut;
	char *ConsoleText;
    int LastServiceUpdate;

    int fDefaultNumAverage;
	int NumAverages;					// Events before feedback acts
	int Count;							// Current number of events
    float Gain;
    float DiffVoltage;					// for response measurement	
	std::vector<std::string> Parameter;
	int TimeBarrier;

    void SetFBMode(FBState);
    void MeasureResponse(float);
    void ClearAverages();
    void PrintMessage(const char*, ...);
	bool Match(std::string, std::string);    
    void PrintUsage();
	void commandHandler();

  public:
    Feedback();
    ~Feedback();

    void cmd_mode();		void cmd_average();
    void cmd_target();		void cmd_gain();
    void cmd_response();	void cmd_config();
    void cmd_data();		void cmd_clear();
	void cmd_help();		void cmd_exit();
};

#endif
