#ifndef HVFEEDBACK_H_SEEN
#define HVFEEDBACK_H_SEEN

#define BUF_LENGTH 1000

#include <stdlib.h>

#include "RawDataCTX.h"
#include "DAQReadout.h"

enum FBState {FB_Off, FB_Active, FB_Targets, FB_ResponseFirst, FB_ResponseSecond};

class HVFeedback {

    class DAQReadout *m;
    class PixelMap *PixMap;    
    FBState FBMode;
    
    float (*Average)[kNumberOfChips][kNumberOfChannels];
    float (*Response)[kNumberOfChips][kNumberOfChannels];
    float (*Target)[kNumberOfChips][kNumberOfChannels];
    float (*Buffer)[kNumberOfChips][kNumberOfChannels];
    
    unsigned int NumAverages;	// Events to take before feedback acts
    unsigned int Count;		// Number of currently integrated events
    
    float Gain;     	    	// Feedback gain
    float Voltage1, Voltage2;	// for response measurement	
    int SocketDescriptor;
    char TextBuf[BUF_LENGTH];
	
    int fLedTrigBoard;
    int fLedTrigChip;
    int fLedTrigChannel;
    int fLedTrigSample;
    float fLedTrigThreshold;
    int fLedSignalSample;
    int fLedBaselineSample;
    int fDefaultNumAverage;
    char fHVControlServer[BUF_LENGTH];
    int fHVControlPort;
    int fMaxCmdAckDelay;
   	    	  
  public:
    HVFeedback(class DAQReadout*, char*);
    ~HVFeedback();

    bool ProcessEvent();
    void SetTarget(int, int, int, float);
    void GetTargets();
    void SetGain(float);
    float GetGain();
    void SetNumAverages(unsigned int);
    unsigned int GetNumAverages();
    void SetFBMode(FBState);
    FBState GetFBMode();
    unsigned int GetCurrentCount();
    void MeasureResponse(float, float);
    void GetResponse();
    void ClearAverages();
    bool WriteHVCommand(const char *, ...);
    void PrintConfig();
};

#endif
