#ifndef MARS_MCalibrationCam
#define MARS_MCalibrationCam

#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

#ifndef MARS_MCalibrationPix
#include "MCalibrationPix.h"
#endif

#ifndef MARS_MCalibrationBlindPix
#include "MCalibrationBlindPix.h"
#endif

#ifndef MARS_MCalibrationPINDiode
#include "MCalibrationPINDiode.h"
#endif

#ifndef ROOT_TClonesArray
#include <TClonesArray.h>
#endif

#ifndef ROOT_TH1F
#include <TH1F.h>
#endif

#ifndef ROOT_TH1D
#include <TH1D.h>
#endif

#ifndef ROOT_TH2D
#include <TH2D.h>
#endif

class MGeomCam;
class MCalibrationPix;
class MCalibrationBlindPix;
class MCalibrationPINDiode;

class MCalibrationCam : public MCamEvent
{
private:
  
  Int_t fNumPixels;
  TClonesArray *fPixels;                      // Array of MCalibrationPix with fit results
  
  MCalibrationBlindPix *fBlindPixel;          // Pointer to the Blind Pixel with fit results
  MCalibrationPINDiode *fPINDiode;            // Pointer to the PIN Diode with fit results    

  Bool_t  fNumPhotInsidePlexiglassAvailable;  // TRUE: Blind Pixel could have been fitted well 
  Float_t fMeanPhotInsidePlexiglass;          //  The mean number of photons in an INNER PIXEL inside the plexiglass
  Float_t fMeanPhotErrInsidePlexiglass;       //  The uncertainty about the number of photons in an INNER PIXEL  

  Bool_t  fNumPhotOutsidePlexiglassAvailable; // TRUE: PIN Diode could have been fitted well 
  Float_t fMeanPhotOutsidePlexiglass;         //  The mean number of photons in an INNER PIXEL outside the plexiglass
  Float_t fMeanPhotErrOutsidePlexiglass;      //  The uncertainty about the number of photons in an INNER PIXEL  

  TH1F* fHChargeAllPixels;                     //! 
  TH1F* fHChargeErrAllPixels;                  //! 
  TH1F* fHChargeSigmaAllPixels;                //! 
  TH1F* fHChargeProbAllPixels;                 //! 

  TH1F* fHTimeAllPixels;                       //! 
  TH1F* fHTimeSigmaAllPixels;                  //! 
  TH1F* fHTimeProbAllPixels;                   //! 

  TH1F* fHPedAllPixels;                        //! 
  TH1F* fHPedRMSAllPixels;                     //! 
  TH1F* fHSigmaPerChargeAllPixels;             //! 
  TH1F* fHPhEAllPixels;                        //! 

  TH1F* fHConvPhEperFADCAllPixels;             //! 
  TH1F* fHConvPhperFADCAllPixels;              //! 

  TH1D* fOffsets;                              //! 
  TH1D* fSlopes;                               //! 
  
  TH2D* fOffvsSlope;                           //! 

public:
  
  enum CalibrationColor_t { kECGreen, kECBlue, kECUV, kECCT1 };

private:

  CalibrationColor_t fColor;  
  
public:

  MCalibrationCam(const char *name=NULL, const char *title=NULL);
  ~MCalibrationCam();
  
  void Clear(Option_t *o="");
  
  void InitSize(const Int_t i);
  Int_t GetSize() const;

  UInt_t GetNumPixels() const { return fNumPixels; }

  Bool_t IsPixelUsed(Int_t idx)      const;
  Bool_t IsPixelFitted(Int_t idx)    const;
  Bool_t IsPixelFitValid(Int_t idx)  const;  
  
  MCalibrationPix &operator[](Int_t i);
  MCalibrationPix &operator[](Int_t i) const;
  
  Bool_t CheckBounds(Int_t i) const;

  void Print(Option_t *o="") const;
  
  void CutEdges();
  
  Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
  void   DrawPixelContent(Int_t num) const;    
  
  MCalibrationBlindPix *GetBlindPixel()              const { return fBlindPixel;  }
  MCalibrationPINDiode *GetPINDiode()                const { return fPINDiode;    }

  void SetColor(CalibrationColor_t color)    { fColor = color; }

  Bool_t GetConversionFactorFFactor(Int_t ipx, Float_t &mean, Float_t &err, Float_t &sigma);
  Bool_t GetConversionFactorBlindPixel(Int_t ipx, Float_t &mean, Float_t &err, Float_t &sigma);
  Bool_t GetConversionFactorPINDiode(Int_t ipx, Float_t &mean, Float_t &err, Float_t &sigma);
  Bool_t GetConversionFactorCombined(Int_t ipx, Float_t &mean, Float_t &err, Float_t &sigma);

  Bool_t CalcNumPhotInsidePlexiglass();
  Bool_t CalcNumPhotOutsidePlexiglass();

  void DrawHiLoFits();

  ClassDef(MCalibrationCam, 1)	// Storage Container for all calibration information of the camera
};

#endif

