#ifndef MARS_MMcCalibrationCalc
#define MARS_MMcCalibrationCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MCalibrationCam;
class MPedPhotCam;
class MGeomCam;
class MMcFadcHeader;
class MExtractedSignalCam;

class MMcCalibrationCalc : public MTask
{
private:
    Bool_t CheckRunType(MParList *pList) const;
    Int_t  PreProcess(MParList *pList);
    Int_t  Process();
    Bool_t ReInit(MParList *pList);

    MCalibrationCam     *fCalCam;
    MPedPhotCam         *fPedPhotCam;
    MGeomCam            *fGeom;
    MMcFadcHeader       *fHeaderFadc;
    MExtractedSignalCam *fSignalCam;

    Float_t fADC2PhInner; // Conversion factor from ADC counts to photons
    Float_t fADC2PhOuter; // for inner and outer pixels.

    Float_t fConversionHiLo;

public:
    MMcCalibrationCalc(const char *name=NULL, const char *title=NULL);

    void SetADC2PhInner(Float_t x);
    void SetConversionHiLo(Float_t x) { fConversionHiLo = x; }

    ClassDef(MMcCalibrationCalc, 0)   // Task which obtains, for MC files, the pedestal mean and rms, and the calibration factor from ADC counts to photons. 
};

#endif
