library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
-- use IEEE.NUMERIC_STD.ALL;

package ftu_array_types is

  type enable_array_type is array (0 to 3) of std_logic_vector(15 downto 0);
  constant DEFAULT_ENABLE : enable_array_type := ("0000000111111111", --patch A
                                                  "0000000111111111", --patch B
                                                  "0000000111111111", --patch C
                                                  "0000000111111111");--patch D
  
  type dac_array_type is array (0 to 7) of integer range 0 to 2**12 - 1;
  constant DEFAULT_DAC : dac_array_type := (500, 500, 500, 500, 0, 0, 0, 100);
   
end ftu_array_types;
