#ifndef MARS_MArrivalTime
#define MARS_MArrivalTime

#ifndef ROOT_TArrayF
#include <TArrayF.h>
#endif
#ifndef ROOT_TSpline
#include <TSpline.h>
#endif
#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

class MGeomCam;
class MRawEvtData;
class MRawEvtPixelIter;

class MArrivalTime : public MCamEvent
{
private:
    TArrayF fData;  // Stores the arrival times

public:
    MArrivalTime(const char *name=NULL, const char *title=NULL);
    ~MArrivalTime() { }

    UInt_t GetNumPixels() const { return fData.GetSize(); }

    void Calc(const MRawEvtData &evt, const MGeomCam &geom); // Calculates arrival times

    const TArrayF &GetData() const { return fData; }

    Double_t operator[](int i) { return fData[i]; }

    Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
    void DrawPixelContent(Int_t num) const;

    ClassDef(MArrivalTime, 0)    // class for an event containing the arrival times
};

#endif
