#ifndef MARS_MArrivalTimeCalc
#define MARS_MArrivalTimeCalc

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MArrivalTimeCalc                                                        //
//                                                                         //
// Evaluates the Arrival Times                                             //
//                                                                         //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MRawEvtData;
class MCameraData;
class MRawRunHeader;
class MGeomCam;
class MArrivalTime;

class MArrivalTimeCalc : public MTask
{
    MRawEvtData    *fRawEvt;     // raw event data (time slices)
    MCameraData    *fCamData;    // Cerenkov Photon Event used for calculation
    MRawRunHeader  *fRunHeader;  // RunHeader information
    MGeomCam       *fGeom;       // Geometry information
    MArrivalTime   *fArrTime;    // Container with the photons arrival times

    Bool_t          fEnableFix;  // fix for a bug in files from older camera versions (<=40)
    Bool_t          fIsMcFile;

    Int_t PreProcess(MParList *pList);
    Int_t Process();
    Int_t PostProcess() {return kTRUE;}
    Bool_t ReInit(MParList *pList) {
        return kTRUE;
    }

public:
    MArrivalTimeCalc(const char *name=NULL, const char *title=NULL);

    ~MArrivalTimeCalc(){}

    ClassDef(MArrivalTimeCalc, 0)   // Task to calculate Arrival Times from raw data
};


#endif
