#ifndef MARS_MArrivalTime
#define MARS_MArrivalTime

#ifndef ROOT_TArrayF
#include <TArrayF.h>
#endif
#ifndef ROOT_TArrayS
#include <TArrayS.h>
#endif
#ifndef ROOT_TSpline
#include <TSpline.h>
#endif
#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

class MGeomPix;
class MRawEvtData;
class MRawEvtPixelIter;

class MArrivalTime : public MCamEvent
{
private:
    TArrayF fData;  // Stores the arrival times
 
    TArrayF fData2; // Clusters with at most 2 pix 
    TArrayF fData3; // Clusters with at most 3 pix                      
    TArrayF fData4; // Clusters with at most 4 pix                      
    TArrayF fData5; // Clusters with at most 5 pix 

    Bool_t  *fPixelChecked; // For each pixel says if it's already been checked
    TArrayS fCluster; // Idxs of the pixels in the current cluster
    TArrayS fakeData; //Test purpose
public:
    MArrivalTime(const char *name=NULL, const char *title=NULL);
    ~MArrivalTime() { }

    UInt_t GetNumPixels() const { return fData.GetSize(); }

    void Calc(const MRawEvtData &evt, const MGeomCam &geom); // Calculates arrival times

    void  MArrivalTime::EvalClusters(const MRawEvtData &evt, const MGeomCam &geom);

    void MArrivalTime::CheckNeighbours(const MRawEvtData &evt, const MGeomCam &geom,
				       Short_t idx, Short_t *dimCluster);

    const TArrayF &GetData() const { return fData; }

    Double_t operator[](int i) { return fData[i]; }

    Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
    void DrawPixelContent(Int_t num) const;

    ClassDef(MArrivalTime, 0)    // class for an event containing the arrival times
};

#endif
