#ifndef MARS_MExtractedSignalPix
#define MARS_MExtractedSignalPix

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MExtractedSignalPix : public MParContainer
{
private:

  Float_t fExtractedSignalHiGain;      // mean value of the extracted signal
  Float_t fExtractedSignalHiGainError; // error of the mean value of the extracted signal
  Float_t fExtractedSignalLoGain;      // mean value of the extracted signal
  Float_t fExtractedSignalLoGainError; // error of the mean value of the extracted signal

  Bool_t fIsLoGainUsed;
  Byte_t fNumHiGainSaturated;
  Byte_t fNumLoGainSaturated;

    // FIXME: Will be removed. Must be stored in MArrivalTime
  Float_t fMeanArrivalTime;
  Float_t fWidthArrivalTime;
  Float_t fTailArrivalTime;

public:

    MExtractedSignalPix(const char* name=NULL, const char* title=NULL);

    void Clear(Option_t *o="");

    // Setter
    void SetExtractedSignal(Float_t sig, Float_t sigerr)   
    {
        fExtractedSignalHiGain = sig; fExtractedSignalHiGainError = sigerr;
    }

    void SetExtractedSignal(Float_t sighi, Float_t sighierr,Float_t siglo, Float_t sigloerr)   
    {
        fExtractedSignalHiGain = sighi;
        fExtractedSignalHiGainError = sighierr;
        fExtractedSignalLoGain = siglo;
        fExtractedSignalLoGainError = sigloerr;
    }

    void SetGainSaturation(Bool_t sat, Byte_t higain, Byte_t logain) 
    {
        fIsLoGainUsed = sat; fNumHiGainSaturated = higain; fNumLoGainSaturated = logain;
    }

    void SetArrivalTimes(Float_t mean, Float_t width, Float_t tail) 
    {
        fMeanArrivalTime = mean; fWidthArrivalTime = width; fTailArrivalTime = tail;
    }

    // Getter
    Float_t GetExtractedSignalHiGain()      const { return fExtractedSignalHiGain; }
    Float_t GetExtractedSignalHiGainError() const { return fExtractedSignalHiGainError; }

    Float_t GetExtractedSignalLoGain()      const { return fExtractedSignalLoGain; }
    Float_t GetExtractedSignalLoGainError() const { return fExtractedSignalLoGainError; }

    Float_t GetMeanArrivalTime()            const { return fMeanArrivalTime; }
    Float_t GetWidthArrivalTime()           const { return fWidthArrivalTime; }
    Float_t GetTailArrivalTime()            const { return fTailArrivalTime; }


    Bool_t IsLoGainUsed() const { return fIsLoGainUsed; }
    Bool_t IsValid() const      { return fExtractedSignalHiGain >= 0. || fExtractedSignalHiGainError >= 0.; }

    void PrintOut();

    ClassDef(MExtractedSignalPix, 0)	// Storage Container for Extracted Signal information of one pixel
};

#endif

