#ifndef MARS_MExtractedSignalCam
#define MARS_MExtractedSignalCam

#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

class TClonesArray;
class MExtractedSignalPix;

class MExtractedSignalCam : public MCamEvent
{
private:
    TClonesArray *fArray; // FIXME: Change TClonesArray away from a pointer?

    Byte_t fFirstUsedSliceHiGain;
    Byte_t fFirstUsedSliceLoGain;

    Byte_t fLastUsedSliceHiGain;
    Byte_t fLastUsedSliceLoGain;

public:

    MExtractedSignalCam(const char *name=NULL, const char *title=NULL);
    ~MExtractedSignalCam();

    void Clear(Option_t *o="");

    void InitSize(const UInt_t i);
    Int_t GetSize() const;

    Byte_t GetNumUsedFADCSlices()          { return fLastUsedSliceHiGain-fFirstUsedSliceHiGain+1; }
    Byte_t GetNumUsedHiGainFADCSlices()    { return fLastUsedSliceHiGain-fFirstUsedSliceHiGain+1; }
    Byte_t GetNumUsedLoGainFADCSlices()    { return fLastUsedSliceLoGain-fFirstUsedSliceLoGain+1; }

    Byte_t GetFirstUsedSliceHiGain()       { return fFirstUsedSliceHiGain; }
    Byte_t GetLastUsedSliceHiGain()        { return fLastUsedSliceHiGain; }

    Byte_t GetFirstUsedSliceLoGain()       { return fFirstUsedSliceLoGain; }
    Byte_t GetLastUsedSliceLoGain()        { return fLastUsedSliceLoGain; }

    void   SetUsedFADCSlices(Byte_t firsth, Byte_t lasth, 
                       Byte_t firstl, Byte_t lastl)
    {
      fFirstUsedSliceHiGain    = firsth;
      fLastUsedSliceHiGain     = lasth;
      fFirstUsedSliceLoGain    = firstl;
      fLastUsedSliceLoGain     = lastl;
    }

    MExtractedSignalPix &operator[](Int_t i);
    MExtractedSignalPix &operator[](Int_t i) const;

    void Print(Option_t *o="") const;

    Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
    void DrawPixelContent(Int_t num) const;

    ClassDef(MExtractedSignalCam, 0)	// Storage Container for extracted signals in the camera
};

#endif

