#ifndef MARS_MPedPhotCalc
#define MARS_MPedPhotCalc

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MPedPhotCalc                                                            //
//                                                                         //
// Evaluate the pedestals from pedestal runs using charge extraction       //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

#include <TArrayF.h>

class MPedPhotCam;
class MRawEvtData;
class MCerPhotEvt;

class MPedPhotCalc : public MTask
{
    UShort_t fNumPixels;

    MPedPhotCam  *fPedestals;  // Pedestals of all pixels in the camera
    MCerPhotEvt  *fCerPhot;

    TArrayF fSumx;   // sum of values
    TArrayF fSumx2;  // sum of squared values

    Bool_t ReInit(MParList *pList);

    Int_t PreProcess(MParList *pList);
    Int_t Process();
    Int_t PostProcess();

public:
    MPedPhotCalc(const char *name=NULL, const char *title=NULL);

    ClassDef(MPedPhotCalc, 0)   // Task to calculate pedestals from pedestal runs raw data
};

#endif
