#ifndef MARS_MHCalibrationPINDiode
#define MARS_MHCalibrationPINDiode

#ifndef MARS_MHCalibrationPixel
#include "MHCalibrationPixel.h"
#endif

class TH1I;
class TH1F;
class TF1;

class MHCalibrationPINDiode : public MHCalibrationPixel
{
private:

  TH1I* fHPCharge;           //-> Histogram containing the summed 32 PINDiode slices
  TH1F* fHErrCharge;         //-> Variance of summed FADC slices
  TH1I* fHPTime;             //-> Histogram with time evolution of summed charges
  
  
  TF1 *fVarGausFit;
  
  Float_t  fErrChargeFirst;
  Float_t  fErrChargeLast;
  UShort_t fErrChargeNbins;

public:

  MHCalibrationPINDiode(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationPINDiode();

  const Double_t GetTime() const;
  const Double_t GetErrTime() const;

  ClassDef(MHCalibrationPINDiode, 0)  // Histograms from the Calibration PIN Diode
};

#endif

