#ifndef MARS_MMcCalibrationCalc
#define MARS_MMcCalibrationCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MCalibrationCam;
class MGeomCam;
class MHillas;
class MNewImagePar;
class MMcEvt;
class MMcFadcHeader;

class TH1F;

class MMcCalibrationCalc : public MTask
{
private:
    MCalibrationCam     *fCalCam;
    MGeomCam            *fGeom;
    MHillas             *fHillas;
    MNewImagePar        *fNew;
    MMcEvt              *fMcEvt;
    MMcFadcHeader       *fHeaderFadc;

    Float_t fADC2Phot;
    Long_t  fEvents;

    TH1F*   fHistRatio;

    Bool_t CheckRunType(MParList *pList) const;
    Int_t  PreProcess(MParList *pList);
    Int_t  Process();
    Int_t  PostProcess();
    Bool_t ReInit(MParList *pList);

public:
    MMcCalibrationCalc(const char *name=NULL, const char *title=NULL);

    ClassDef(MMcCalibrationCalc, 0)   // Task which obtains, for MC files, the calibration factor from ADC counts to photons. 
};

#endif
