#include <string>

#include <QtGui>
#include <QtNetwork/QTcpSocket>
#include <QtNetwork/QAbstractSocket>

#include <qwt_plot.h>
#include <qwt_plot_curve.h>
#include <qwt_plot_grid.h>
#include <qwt_plot_zoomer.h>
#include <qwt_plot_panner.h>

#include "../../drsdaq/RawDataCTX.h"
#include "../../pixelmap/PixelMap.h"

#define SOCKET_TIMEOUT 10000	// Milliseconds to wait for socket connection
#define MAX_OUTPUT_LINES 200	// Maximum number of lines in socket output window
#define MAX_COM_SIZE 10000
#define INITIAL_DIRECTORY ""

// Main window class
class ddd : public QMainWindow {
    Q_OBJECT
    
    QPushButton *GetButton, *SocketButton, *Connect;
    QCheckBox *ContinuousBox;
    QToolButton *LoadButton;
    QLineEdit *FilenameBox, *IPAddress, *Command, *PixelID;
    QSpinBox *EventNo, *ChannelNo, *BoardNo, *Port;
    QPlainTextEdit *RunHeaderDisplay, *EventHeaderDisplay, *SocketOutput;
    QTabWidget *TabWidget;
    QTcpSocket *Socket;
    QWidget *SocketWindow, *Central;
    QAction *OpenAction, *ConnectAction;
    QGridLayout *SocketLayout, *MainLayout;
    QFormLayout *CommandLayout, *PortLayout, *AddressLayout, *FormLayout, *SpinLayout;
    
    QwtPlot *Graph;
    QwtPlotZoomer *Zoomer;
    QwtPlotCurve *Signal;
    QwtPlotPanner *Panner;
    QwtPlotGrid *Grid;

    void closeEvent(QCloseEvent *); 

    bool ManualDisconnect, WaitForData;
    RawDataCTX *RD;
    PixelMap *PixMap;
      
  public:
    ddd();
    ~ddd();
    void CloseDatafile();
    
  private slots:
    void OpenDatafile();
    void DisplayEvent(int=0);
    void FileDialog();
    void OpenSocketWindow();
    void GetSignalFromSocket();
    void MakeConnection();
    void SendToSocket();
    void ReadFromSocket();
    void GotDisconnected();
    void TranslatePixelID();
    
    void MenuSave();
    void MenuPrint();
    void MenuHelp();
    void MenuAbout();
};

