#ifndef MARS_MCalibrationPINDiode
#define MARS_MCalibrationPINDiode

#ifndef MARS_MHCalibrationPINDiode
#include "MHCalibrationPINDiode.h"
#endif

class MCalibrationPINDiode : public MParContainer
{
private:

  MHCalibrationPINDiode *fHist; // Pointer to the histograms performing the fits, etc.  
  
  Float_t fCharge;                // The mean charge after the fit
  Float_t fErrCharge;             // The error of mean charge after the fit
  Float_t fPed;              // The mean pedestal (from MPedestalPix)
  Float_t fPedRms;           // The pedestal  RMS (from MPedestalPix)
  Float_t fSigmaCharge;           // The sigma of the mean charge after the fit
  Float_t fErrSigmaCharge;        // The error of the sigma of the mean charge after the fit
  Float_t fTime;                // The mean arrival time after the fit  
  Float_t fErrTime;             // The error of the mean arrival time after the fit
  
public:

  MCalibrationPINDiode(const char *name=NULL, const char *title=NULL);
  ~MCalibrationPINDiode();
  
  void Clear(Option_t *o="");
  
  void SetPed(Float_t ped)          { fPed      = ped;      } 
  void SetPedRms(Float_t pedrms)    { fPedRms   = pedrms; }

  Float_t GetMean()           const { return fCharge; }
  Float_t GetMeanError()      const { return fErrCharge; }

  Bool_t IsFitOK() const            { return fCharge > 0 && fErrCharge > 0; }

  Bool_t FillCharge(Float_t q)      { return fHist->FillChargeHiGain(q); }
  Bool_t FillTime(Float_t t)        { return fHist->FillTimeHiGain(t); }  
  Bool_t FillRChargevsTime(Float_t rq, Int_t t) { return fHist->FillChargevsNHiGain(rq,t); }    
  
  Bool_t FitCharge();
  Bool_t FitTime();
  
  MHCalibrationPINDiode *GetHist()  const  { return fHist;  }
  
  ClassDef(MCalibrationPINDiode, 1)	// Storage Container for Calibration information of one pixel
};

#endif   /* MARS_MCalibrationPINDiode */

