#ifndef MARS_MArrivalTime
#define MARS_MArrivalTime

#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

#ifndef ROOT_TArrayF
#include <TArrayF.h>
#endif
#ifndef ROOT_TArrayS
#include <TArrayS.h>
#endif

class MRawEvtData;

class MArrivalTime : public MCamEvent
{
 private:
    TArrayF fData;  // Stores the arrival times
 
    TArrayF fData2; // Clusters with at most 2 pix 
    TArrayF fData3; // Clusters with at most 3 pix                      
    TArrayF fData4; // Clusters with at most 4 pix                      
    TArrayF fData5; // Clusters with at most 5 pix 

    //Bool_t  *fPixelChecked; // For each pixel says if it's already been checked
    TArrayS fCluster; // Idxs of the pixels in the current cluster
    TArrayS fakeData; //Test purpose

public:

    MArrivalTime(const char *name=NULL, const char *title=NULL);
    ~MArrivalTime() { }

    void   Reset();
    void   InitSize(Int_t i);
    UInt_t GetNumPixels() const { return fData.GetSize(); }

    void SetTime(Int_t i, Float_t time);
    const TArrayF &GetData() const { return fData; }
    Double_t operator[](int i) { return fData[i]; }

    void Calc(const Byte_t *fadcSamples, const Short_t nSlice, const Short_t idx);
    void EvalClusters(const MRawEvtData &evt, const MGeomCam &geom);
    void CheckNeighbours(const MRawEvtData &evt, const MGeomCam &geom,
                         Short_t idx, Short_t *dimCluster);

    Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
    void DrawPixelContent(Int_t num) const;

    ClassDef(MArrivalTime, 0)    // class for an event containing the arrival times
};

#endif
