#ifndef MARS_MArrivalTimeCalc
#define MARS_MArrivalTimeCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MRawEvtData;
class MArrivalTime;

class MArrivalTimeCalc : public MTask
{
private:
    MRawEvtData  *fRawEvt;     // raw event data (time slices)
    MArrivalTime *fArrTime;    // Container with the photons arrival times

    Bool_t ReInit(MParList *pList);
    Int_t  PreProcess(MParList *pList);
    Int_t  Process();
    Int_t  PostProcess() {return kTRUE;}

public:
    MArrivalTimeCalc(const char *name=NULL, const char *title=NULL);
    ~MArrivalTimeCalc(){}

    ClassDef(MArrivalTimeCalc, 0)   // Task to calculate Arrival Times from raw data
};

#endif
