#ifndef MARS_MArrivalTimeCalc
#define MARS_MArrivalTimeCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MRawEvtData;
class MRawRunHeader;
class MArrivalTime;

class MArrivalTimeCalc : public MTask
{

    MRawEvtData    *fRawEvt;     // raw event data (time slices)
    MRawRunHeader  *fRunHeader;  // RunHeader information

    MArrivalTime   *fArrTime;    // Container with the photons arrival times

    Int_t PreProcess(MParList *pList);
    Bool_t ReInit(MParList *pList);
    Int_t Process();
    Int_t PostProcess() {return kTRUE;}

    Float_t Calc(const Byte_t *fadcSamples, const Short_t nslices);
    
public:
    MArrivalTimeCalc(const char *name=NULL, const char *title=NULL);
    ~MArrivalTimeCalc(){}

    ClassDef(MArrivalTimeCalc, 0)   // Task to calculate Arrival Times from raw data
};

#endif
