#ifndef MARS_MJCalibration
#define MARS_MJCalibration

#ifndef MARS_MCalibrationCam
#include "MCalibrationCam.h"
#endif

class TCanvas;
class MHCamera;
class MCamEvent;
class MRunIter;
class MParList;
class MPedestalCam;

class MJCalibration : public MParContainer
{
private:
    TString fOutputPath;

    MRunIter *fRuns;

    MCalibrationCam fCalibrationCam;

    void DrawProjection(MHCamera *obj1, Int_t fit) const;
    void CamDraw(TCanvas &c, Int_t x, Int_t y, MHCamera &cam1, Int_t fit);

    void   DisplayResult(MParList &plist);
    Bool_t WriteResult();

public:
    MJCalibration(const char *name=NULL, const char *title=NULL);

    void SetInput(MRunIter *iter) { fRuns=iter; }
    void SetOutputPath(const char *path=".");

    TString GetOutputFile() const;
    MCalibrationCam &GetCalibrationCam() { return fCalibrationCam; }

    Bool_t ReadCalibrationCam();
    Bool_t ProcessFile(MPedestalCam &pedcam);
    Bool_t Process(MPedestalCam &pedcam);

    ClassDef(MJCalibration, 0) // Tool to create a pedestal file (MPedestalCam)
};

#endif
