/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz, 1/2004 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
//  MRunIter
//
/////////////////////////////////////////////////////////////////////////////
#include "MRunIter.h"

#include <TSystem.h>

ClassImp(MRunIter);

using namespace std;

Int_t MRunIter::AddRun(UInt_t run, const char *path)
{
    TString p(path);

    if (p.IsNull())
        p = fPath;

    if (p.IsNull())
        p = ".";

    MDirIter Next(p, Form("*_%05d_*_*.root", run), -1);

    const TString name(Next());
    if (name.IsNull())
        return 0;

    AddRunNumber(run);

    return AddDirectory(gSystem->DirName(name), gSystem->BaseName(name), -1);
}
