#ifndef MARS_MJExtractSignal
#define MARS_MJExtractSignal

#ifndef MARS_MPedPhotCam
#include "MPedPhotCam.h"
#endif

class TCanvas;
class MHCamera;
class MCamEvent;
class MRunIter;
class MParList;
class MPedestalCam;
class MCalibrationCam;

class MJExtractSignal : public MParContainer
{
private:
    TString fOutputPath;

    MRunIter *fRuns;

    MPedPhotCam fPedPhotCam;

    void   DisplayResult(MParList &plist);
    Bool_t WriteResult();

    Bool_t ReadPedPhotCam();

    Bool_t ProcessFileD(MPedestalCam &pedcam);
    Bool_t ProcessFileP(MPedestalCam &pedcam, MCalibrationCam &calcam);

public:
    MJExtractSignal(const char *name=NULL, const char *title=NULL);

    void SetInput(MRunIter *iter) { fRuns = iter; }
    void SetOutputPath(const char *path=".");

    TString GetOutputFileP() const;
    TString GetOutputFileD() const;

    Bool_t ProcessD(MPedestalCam &pedcam);
    Bool_t ProcessP(MPedestalCam &pedcam, MCalibrationCam &calcam);

    const MPedPhotCam &GetPedPhotCam() const { return fPedPhotCam; }

    ClassDef(MJExtractSignal, 0) // Tool to create a pedestal file (MPedestalCam)
};

#endif
