#ifndef MARS_MJPedestal
#define MARS_MJPedestal

#ifndef MARS_MPedestalCam
#include "MPedestalCam.h"
#endif

class MParList;
class MRunIter;

class MJPedestal : public MParContainer
{
private:
    TString fOutputPath;

    MRunIter *fRuns;

    MPedestalCam fPedestalCam;

    void   DisplayResult(MParList &plist);
    Bool_t WriteResult();

public:
    MJPedestal(const char *name=NULL, const char *title=NULL);

    void SetOutputPath(const char *path=".");
    void SetInput(MRunIter *iter) { fRuns=iter; }

    TString GetOutputFile() const;
    MPedestalCam &GetPedestalCam() { return fPedestalCam; }

    Bool_t ReadPedestalCam();
    Bool_t ProcessFile();
    Bool_t Process();

    ClassDef(MJPedestal, 0) // Tool to create a pedestal file (MPedestalCam)
};

#endif
