#ifndef MARS_MHPedestalPixel
#define MARS_MHPedestalPixel

#ifndef MARS_MH
#include "MH.h"
#endif

class TH1F;
class TH1I;
class TF1;
class MHPedestalPixel : public MH
{

private:

  Int_t fPixId;                  // Pixel Nr

  const Int_t   fChargeNbins;
  Axis_t  fChargeFirst;
  Axis_t  fChargeLast;

  const Int_t   fChargevsNbins;
  const Axis_t  fChargevsNFirst;
  const Axis_t  fChargevsNLast;
  
  TH1F* fHPedestalCharge;               //-> Summed FADC slices
  TH1I* fHPedestalChargevsN;            //-> Summed FADC slices vs Event nr.
  TF1*  fGausFit;                       // Fit the the Summed FADC slices
  
  Int_t    fTotalEntries;              // Number of entries

  Double_t fChargeChisquare;
  Double_t fChargeProb;
  Int_t    fChargeNdf;

  Double_t fChargeMean;
  Double_t fChargeMeanErr;
  Double_t fChargeSigma;
  Double_t fChargeSigmaErr;

  Byte_t   fFlags;

  enum   { kFitted, kFitOK };
  
public:

  MHPedestalPixel(const char *name=NULL, const char *title=NULL);
  ~MHPedestalPixel();

  void Clear(Option_t *o="");
  void Reset();  

  void ChangeHistId(Int_t i);
  
  // Getters
  const TH1F *GetHPedestalCharge() const { return fHPedestalCharge; }

  Double_t GetChargeMean()         const { return fChargeMean;      }
  Double_t GetChargeMeanErr()      const { return fChargeMeanErr;   }
  Double_t GetChargeSigma()        const { return fChargeSigma;     }
  Double_t GetChargeSigmaErr()     const { return fChargeSigmaErr;  }
  Double_t GetChargeChiSquare()    const { return fChargeChisquare; }
  Double_t GetChargeProb()         const { return fChargeProb;      }  
  Int_t    GetChargeNdf()          const { return fChargeNdf;       }

  Int_t    GetTotalEntries()       const { return fTotalEntries;    }     

  Bool_t IsFitOK()     const;    
  Bool_t IsEmpty()     const;
  
  // Fill histos
  Bool_t FillCharge(Float_t q);
  Bool_t FillChargevsN(Float_t q);

  Bool_t SetupFill(const MParList *pList);
  Bool_t Fill(const MParContainer *, const Stat_t w=1) { return kTRUE; }
  
  // Fits
  Bool_t FitCharge(Option_t *option="RQ0");  

  // Draws
  void Draw(Option_t *option="");
  TObject *DrawClone(Option_t *option="") const;
  
  // Prints
  void Print(const Option_t *o="") const;

  // Others
  void CutAllEdges();

  ClassDef(MHPedestalPixel, 1)     // Histograms for each calibrated pixel
};

#endif
