/* ======================================================================== *\
   !
   ! *
   ! * This file is part of MARS, the MAGIC Analysis and Reconstruction
   ! * Software. It is distributed to you in the hope that it can be a useful
   ! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
   ! * It is distributed WITHOUT ANY WARRANTY.
   ! *
   ! * Permission to use, copy, modify and distribute this software and its
   ! * documentation for any purpose is hereby granted without fee,
   ! * provided that the above copyright notice appear in all copies and
   ! * that both that copyright notice and this permission notice appear
   ! * in supporting documentation. It is provided "as is" without express
   ! * or implied warranty.
   ! *
   !
   !
   !   Author(s): Abelardo Moralejo 1/2004 <mailto:moralejo@pd.infn.it>
   !              Thomas Bretz  5/2002 <mailto:tbretz@astro.uni-wuerzburg.de>
   !
   !   Copyright: MAGIC Software Development, 2000-2004
   !
   !
   \* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
//  STARMC2 - STandard Analysis and Reconstruction (MC example)
//
//  This macro converts into image  parameters an input file of MC data 
//  previously calibrated (see mccalibrate.C).
//  
//
/////////////////////////////////////////////////////////////////////////////

#include "MImgCleanStd.h"

void starmc2()
{
  Char_t* AnalysisFilename = "calib_gamma_mc.root"; // File to be analyzed
  Char_t* OutFilename      = "star_mc.root";        // Output file name

  Float_t CleanLev[2] = {4., 3.}; // Tail cuts for image analysis

  // ------------------------------------------------------------------

  //
  // Create a empty Parameter List and an empty Task List
  // The tasklist is identified in the eventloop by its name
  //
  MParList  plist;

  MTaskList tlist;

  plist.AddToList(&tlist);

  MSrcPosCam src;
  src.SetReadyToSave();

  plist.AddToList(&src);

  //
  // Now setup the tasks and tasklist:
  // ---------------------------------
  //
  MReadMarsFile read("Events");

  read.AddFile(AnalysisFilename);

  read.DisableAutoScheme();

  MImgCleanStd      clean(CleanLev[0], CleanLev[1]); // Applies tail cuts to image.

  MHillasCalc       hcalc; // Calculates Hillas parameters not dependent on source position.
  MHillasSrcCalc    scalc; // Calculates source-dependent Hillas parameters 

  tlist.AddToList(&read);
  tlist.AddToList(&clean);
  //    tlist.AddToList(&blind);
  tlist.AddToList(&hcalc);
  tlist.AddToList(&scalc); // Calculates Source-dependent Hillas parameters

  //
  // Open output file:
  //
  MWriteRootFile write(OutFilename); // Writes output
  write.AddContainer("MRawRunHeader", "RunHeaders");
  write.AddContainer("MMcRunHeader",  "RunHeaders");
  write.AddContainer("MSrcPosCam",    "RunHeaders");
  write.AddContainer("MMcEvt",        "Events");
  write.AddContainer("MHillas",       "Events");
  write.AddContainer("MHillasExt",    "Events");
  write.AddContainer("MHillasSrc",    "Events");
  write.AddContainer("MNewImagePar",  "Events");

  tlist.AddToList(&write);            // Add task to write output.

  //
  // analysis loop
  //

  MEvtLoop evtloop;
  MProgressBar bar;
  bar.SetWindowName("Analyzing...");
  evtloop.SetProgressBar(&bar);
  evtloop.SetParList(&plist);

  if (!evtloop.Eventloop())
    return;

  tlist.PrintStatistics();

  return;
}
