#ifndef MARS_MReportTrigger
#define MARS_MReportTrigger

#ifndef MARS_MReport
#include "MReport.h"
#endif
#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

#ifndef ROOT_TArrayF
#include <TArrayF.h>
#endif

class MReportTrigger : public MReport, public MCamEvent
{
private:
    Float_t fL2BeforePrescaler; // L2 trigger rate before prescaler
    Float_t fL2AfterPrescaler;  // L2 trigger rate after prescaler

    TArrayF fPrescalerRates;    //[Hz] L2 prescaler rates
    //TArrayF fRates;           //[Hz] curently undefined

    Int_t InterpreteBody(TString &str);

public:
    MReportTrigger();

    Float_t GetL2BeforePrescaler() const { return fL2BeforePrescaler; }
    Float_t GetL2AfterPrescaler() const { return fL2AfterPrescaler; }

    Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const
      {
  	if(idx<19)
	  {
	    val = fPrescalerRates[idx];
	    return val>0;
	  }
	else
	  val = kFALSE;
      }
    void DrawPixelContent(Int_t num) const
      {
      }

    ClassDef(MReportTrigger, 1) // Class for TRIGGER-REPORT information
};

#endif
