#ifndef MARS_MFCosmics
#define MARS_MFCosmics

#ifndef MARS_MFilter
#include "MFilter.h"
#endif

class MRawEvtData;

class MPedestalCam;
class MExtractedSignalCam;

class MFCosmics : public MFilter
{
private:
    MPedestalCam        *fPedestals; // Pedestals of all pixels in the camera
    MExtractedSignalCam *fSignals;   // Calibration events of all pixels in the camera

    MRawEvtData         *fRawEvt;    // raw event data (time slices)

    Int_t   fCut[2];
    Bool_t  fResult;

    Int_t   fMaxEmptyPixels;         // Maximum number of empty pixels before declaring event as cosmic
    Float_t fSqrtHiGainSamples;      // Square root of the number of used Hi-Gain Samples

    Bool_t ReInit(MParList *pList);
    Int_t  PreProcess(MParList *pList);
    Int_t  Process();
    Int_t  PostProcess();

    Bool_t CosmicsRejection() const;

    Bool_t IsExpressionTrue() const { return fResult; }
  
public:
    MFCosmics(const char *name=NULL, const char *title=NULL);

    void  SetMaxEmptyPixels(const Int_t n) { fMaxEmptyPixels = n; }
    Int_t GetMaxEmptyPixels() const        { return fMaxEmptyPixels; }

    ClassDef(MFCosmics, 0)   // Filter to perform a cosmics rejection
};

#endif
