#ifndef MARS_MHBlindPixels
#define MARS_MHBlindPixels

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef ROOT_TH2
#include <TH2.h>
#endif

class MPedPhotCam;
class MMcEvt;
class MParList;


class MHBlindPixels : public MH
{
private:
    MPedPhotCam   *fPedPhot;      //!
    MMcEvt        *fMcEvt;    //!

    TH2D          fBlindId; // 2D-histogram : pixel Id vs. Theta
    TH2D          fBlindN;  // 2D-histogram : no.of blind pixels vs. Theta

public:
    MHBlindPixels(const char *name=NULL, const char *title=NULL);

    const TH2D *GetBlindId()       { return &fBlindId; }
    const TH2D *GetBlindId() const { return &fBlindId; }

    const TH2D *GetBlindN()       { return &fBlindN; }
    const TH2D *GetBlindN() const { return &fBlindN; }

    TH2 *GetBlinIdByName(const TString name) { return &fBlindId; }
    TH2 *GetBlinNByName(const TString name) { return &fBlindN; }

    void Draw(Option_t* option = "");
    Bool_t SetupFill(const MParList *plist);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);

    ClassDef(MHBlindPixels, 1)  // Histogram of blind pixel Id vs. Theta
};

#endif


