#ifndef MARS_MAGIC
#define MARS_MAGIC
///////////////////////////////////////////////////////////////////////////////
//
//     Magic.h
//
//     defines MAGIC base informations
//
///////////////////////////////////////////////////////////////////////////////
#ifndef ROOT_TROOT
#include <TROOT.h>
#endif

//
// Check here if Mars can be compiled with the present root version
//
#ifndef __CINT__
#if ROOT_VERSION_CODE < ROOT_VERSION(3,05,06)
#error Your root version is too old to compile Mars, use root>=3.05/06
#endif
#endif

//
// Values for the eventloop control
//
const Int_t kCONTINUE = 2;
const Int_t kSKIP     = 2;
const Int_t kERROR    = 3;

//
//     ParticleId for Monte Carlo simulation
//
typedef enum
{
    kGAMMA  =    1,
    kPOSITRON =  2,
    kELECTRON =  3,
    kPROTON =   14,
    kHELIUM =  402,
    kOXYGEN = 1608,
    kIRON   = 5626
} ParticleId_t;

const Double_t kRad2Deg = 180.0/3.1415926535897932384626433832795028841971693993751;

#endif
