#ifndef MARS_MCalibrationConfig
#define MARS_MCalibrationConfig

/////////////////////////////////////////////////////////////////////////////
//                                                                         
// MCalibrationConfig                                                      
//
// Contains all configuration data of the Calibration          
//                                                             
// This file is only TEMPORARY. It values will go into the DATABASE 
//
/////////////////////////////////////////////////////////////////////////////
// ----- BLIND PIXEL ----------------------//

// Average QE of Blind Pixel (three colours)
const Float_t gkCalibrationBlindPixelQEGreen = 0.154;
const Float_t gkCalibrationBlindPixelQEBlue  = 0.226;
const Float_t gkCalibrationBlindPixelQEUV    = 0.247;
const Float_t gkCalibrationBlindPixelQECT1   = 0.247;

// Average QE Error of Blind Pixel (three colours)
const Float_t gkCalibrationBlindPixelQEGreenError = 0.015;
const Float_t gkCalibrationBlindPixelQEBlueError  = 0.02;
const Float_t gkCalibrationBlindPixelQEUVError    = 0.02;
const Float_t gkCalibrationBlindPixelQECT1Error   = 0.02;

// Attenuation factor Blind Pixel (three colours)
const Float_t gkCalibrationBlindPixelAttGreen = 1.97;
const Float_t gkCalibrationBlindPixelAttBlue  = 1.96;
const Float_t gkCalibrationBlindPixelAttUV    = 1.95;
const Float_t gkCalibrationBlindPixelAttCT1   = 1.95;

const Float_t gkCalibrationOutervsInnerPixelArea      = 4.0;
const Float_t gkCalibrationOutervsInnerPixelAreaError = 0.2;

// ----- PIN DIODE ------------------------//

//
// Area of Inner Pixel w.r.t. PIN Diode (which is 1 cm)
//
// Distance of PIN Diode to pulser D1:   1.5  +- 0.3 m
// Distance of Inner Pixel to pulser D2: 18.0 +- 0.5 m
//
//
//                 D1*D1
// conversion C = ------ = 0.0069
//                 D2*D2
//
// Delta C / C  = 2 * Sqrt( (Delta D1/D1) + (Delta D2/D2) )
// Delta C / C  = 0.4
// 
// C = 0.007 +- 0.003
//
const Float_t gkCalibrationFluxCameravsPINDiode      = 0.007;
const Float_t gkCalibrationFluxCameravsPINDiodeError = 0.003;

//
// Average QE of the PIN Diode
//
const Float_t gkCalibrationPINDiodeQEGreen = -1.0;
const Float_t gkCalibrationPINDiodeQEBlue  = -1.0;
const Float_t gkCalibrationPINDiodeQEUV    = -1.0;
const Float_t gkCalibrationPINDiodeQECT1   = -1.0;

//
// Average QE of the PIN Diode
//
const Float_t gkCalibrationPINDiodeQEGreenError = -1.0;
const Float_t gkCalibrationPINDiodeQEBlueError  = -1.0;
const Float_t gkCalibrationPINDiodeQEUVError    = -1.0;
const Float_t gkCalibrationPINDiodeQECT1Error   = -1.0;

#endif /* MARS_MCalibrationConfig */
