#ifndef MARS_MCalibrationConfig
#define MARS_MCalibrationConfig

/////////////////////////////////////////////////////////////////////////////
//                                                                         
// MCalibrationConfig                                                      
//
// Contains all configuration data of the Calibration          
//                                                             
// This file is only TEMPORARY. It values will go into the DATABASE 
//
/////////////////////////////////////////////////////////////////////////////
// ----- PIN DIODE ------------------------//

//
// Area of Inner Pixel w.r.t. PIN Diode (which is 1 cm)
//
// Distance of PIN Diode to pulser D1:   1.5  +- 0.3 m
// Distance of Inner Pixel to pulser D2: 18.0 +- 0.5 m
//
//
//                 D1*D1
// conversion C = ------ = 0.0069
//                 D2*D2
//
// Delta C / C  = 2 * Sqrt( (Delta D1/D1) + (Delta D2/D2) )
// Delta C / C  = 0.4
// 
// C = 0.007 +- 0.003
//
const Float_t gkCalibrationFluxCameravsPINDiode      = 0.007;
const Float_t gkCalibrationFluxCameravsPINDiodeErr   = 0.003;

//
// Average QE of the PIN Diode
//
const Float_t gkCalibrationPINDiodeQEGreen = -1.0;
const Float_t gkCalibrationPINDiodeQEBlue  = -1.0;
const Float_t gkCalibrationPINDiodeQEUV    = -1.0;
const Float_t gkCalibrationPINDiodeQECT1   = -1.0;

//
// Average QE of the PIN Diode
//
const Float_t gkCalibrationPINDiodeQEGreenErr = -1.0;
const Float_t gkCalibrationPINDiodeQEBlueErr  = -1.0;
const Float_t gkCalibrationPINDiodeQEUVErr    = -1.0;
const Float_t gkCalibrationPINDiodeQECT1Err   = -1.0;

#endif /* MARS_MCalibrationConfig */
