/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Javier Lpez, 12/2003 <mailto:jlopez@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */

Bool_t HandleInput()
{
    TTimer timer("gSystem->ProcessEvents();", 50, kFALSE);

    while (1)
    {
        //
        // While reading the input process gui events asynchronously
        //
        timer.TurnOn();
        TString input = Getline("Type 'q' to exit, <return> to go on: ");
        timer.TurnOff();

        if (input=="q\n")
            return kFALSE;

        if (input=="\n")
            return kTRUE;
    };

    return kFALSE;
}

void bootcampstandardanalysis(
TString pedname="/mnt/magic_data/Data/rootdata/2003_11_29/20031128_03127_P_Crab-Nebula_E.root",
TString calname="/mnt/magic_data/Data/rootdata/2003_11_29/20031128_03128_C_Crab-Nebula_E.root", 
TString dataname="/mnt/magic_data/Data/rootdata/2003_11_29/20031128_03200_D_Crab-Nebula_E.root")
{

// Before starting be sure you have the pedestal, calibration and data runs names
//    if (pedname != NULL)
//	cout << endl << "usage: bootcampstandardanalysis.C()" << endl; 

    //
    // Create a empty Parameter List and an empty Task List
    // The tasklist is identified in the eventloop by its name
    //
    MParList plist;

    MTaskList tlist;
    plist.AddToList(&tlist);

    //
    // Now setup the tasks and tasklist for the pedestals:
    // ---------------------------------------------------
    //

    MPedestalCam   pedcam;
    plist.AddToList(&pedcam);


    //tasks
    MReadMarsFile read("Events", pedname);
    read.DisableAutoScheme();

    MGeomApply     geomapl;
    MPedCalcPedRun pedcalc;
    MGeomCamMagic  geomcam;

    tlist.AddToList(&read);
    tlist.AddToList(&geomapl);
    tlist.AddToList(&pedcalc);

    //
    // Create and setup the eventloop
    //
    MEvtLoop evtloop;
    evtloop.SetParList(&plist);

    //
    // Execute first analysis
    //
    if (!evtloop.Eventloop())
        return;

    tlist.PrintStatistics();

    //
    // Create a empty Parameter List and an empty Task List
    //
    MParList  plist2;

    MTaskList tlist2;
    plist2.AddToList(&tlist2);


    //
    // Now setup the new tasks and tasklist for the calibration
    // ---------------------------------------------------
    //

    MCalibrationChargeCam   calcam;
    MExtractedSignalCam     sigcam;
    MCalibrationChargePINDiode pindiode;
    
    //
    // As long, as we don't have digital modules, 
    // we have to set the color of the pulser LED by hand
    //
    calcam.SetColor(MCalibrationChargeCam::kECT1);
    pindiode.SetColor(MCalibrationChargePINDiode::kECT1);

    plist2.AddToList(&geomcam);
    plist2.AddToList(&pedcam);
    plist2.AddToList(&calcam);
    plist2.AddToList(&sigcam);
    plist2.AddToList(&pindiode);

   // hists
    MFillH fillpin("MHCalibrationChargePINDiode", "MExtractedSignalPINDiode");

    //tasks
    MReadMarsFile read2("Events", calname);
    read2.DisableAutoScheme();

    MExtractPINDiode       pincalc;
    MExtractBlindPixel     blindcalc;
    MExtractSignal         sigsig;
    MCalibrationChargeCalc calcalc;

    // 
    // Apply a filter against cosmics
    // (was directly in MCalibrationCalc in earlier versions)
    //
    MFCosmics            cosmics;
    MContinue            cont(&cosmics);

    tlist2.AddToList(&read2);
    tlist2.AddToList(&geomapl);
    tlist2.AddToList(&blindcalc);
    tlist2.AddToList(&pincalc);
    tlist2.AddToList(&sigsig);
    //
    // In case, you want to skip the cosmics rejection, 
    // uncomment the next line
    //
    tlist2.AddToList(&cont);
    //
    tlist2.AddToList(&fillpin);
    tlist2.AddToList(&calcalc);
    //
    // Create and setup the eventloop
    //
    MEvtLoop evtloop2;
    evtloop2.SetParList(&plist2);

    //
    // Execute second analysis
    //
    if (!evtloop2.Eventloop())
        return;

    tlist2.PrintStatistics();
 

    //
    // Create a empty Parameter List and an empty Task List
    //
    MParList  plist3;

    MTaskList tlist3;
    plist3.AddToList(&tlist3);

    //
    // Now setup the tasks and tasklist to calculate the pedestal rms in number of photons
    // -----------------------------------------------------------------------------------
    //

    MCerPhotEvt    nphot;
    MPedPhotCam    nphotrms;

    plist3.AddToList(&geomcam);
    plist3.AddToList(&pedcam);
    plist3.AddToList(&calcam);
    plist3.AddToList(&nphot);
    plist3.AddToList(&nphotrms);

    //tasks
    MReadMarsFile read3("Events", pedname);
    read3.DisableAutoScheme();

    MExtractSignal     extsig;
    MCalibrate       photcalc;
//    MPedPhotCalc  photrmscalc;  //It doesn't exist yet

    tlist3.AddToList(&read3);
    tlist3.AddToList(&geomapl);
    tlist3.AddToList(&extsig);
    tlist3.AddToList(&photcalc);
//    tlist3.AddToList(&photrmscalc);

    //
    // Create and setup the eventloop
    //
    MEvtLoop evtloop3;
    evtloop3.SetParList(&plist3);


    //
    // Execute first analysis
    //
    if (!evtloop3.Eventloop())
        return;

    tlist3.PrintStatistics();

    //
    // Create a empty Parameter List and an empty Task List
    //
    MParList  plist4;

    MTaskList tlist4;
    plist4.AddToList(&tlist4);

    //
    // Now setup the tasks and tasklist to analize the data
    // -----------------------------------------------------
    //

    plist4.AddToList(&geomcam);
    plist4.AddToList(&pedcam);
    plist4.AddToList(&calcam);
    plist4.AddToList(&nphot);
    plist4.AddToList(&nphotrms);

    //tasks
    MReadMarsFile read4("Events", dataname);
    read4.DisableAutoScheme();


    MExtractSignal     extsig;
    MCalibrate       photcalc;

    tlist4.AddToList(&read4);
    tlist4.AddToList(&geomapl);
    tlist4.AddToList(&extsig);
    tlist4.AddToList(&photcalc);

    //
    // Create and setup the eventloop
    //
    MEvtLoop evtloop4;
    evtloop4.SetParList(&plist4);

    if (!evtloop4.PreProcess())
        return;

    TCanvas *c = new TCanvas;
    MHCamera display(geomcam);
    display.SetPrettyPalette();
    //display.SetInvDeepBlueSeaPalette()
    display.Draw();
    gPad->SetLogy();
    gPad->cd(1);

    while (tlist4.Process())
    {
      display.SetCamContent(nphot);

      gPad->Modified();
      gPad->Update();

      // Remove the comments if you want to go through the file
      // event-by-event:
      if (!HandleInput())
	break;
    }


    
    evtloop4.PostProcess();

}
