/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Markus Gaug 02/2004 <mailto:markus@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */

//////////////////////////////////////////////////////////////////////////////
//
//  MHCalibrationChargeHiGainPix
//
//  Performs all the necessary fits to extract the mean number of summed FADC slices
//
//////////////////////////////////////////////////////////////////////////////
#include "MHCalibrationChargeHiGainPix.h"

#include <TH1.h>
#include <TPad.h>
#include <TVirtualPad.h>
#include <TCanvas.h>

#include "MLog.h"
#include "MLogManip.h"

#include "MParList.h"

#include "MExtractedSignalCam.h"


ClassImp(MHCalibrationChargeHiGainPix);

using namespace std;

const Int_t   MHCalibrationChargeHiGainPix::fgChargeNbins     = 200;
const Axis_t  MHCalibrationChargeHiGainPix::fgChargeFirst     = -0.5;
const Axis_t  MHCalibrationChargeHiGainPix::fgChargeLast      = 199.5;
const Int_t   MHCalibrationChargeHiGainPix::fgAbsTimeNbins    = 30;
const Axis_t  MHCalibrationChargeHiGainPix::fgAbsTimeFirst    = -0.5;
const Axis_t  MHCalibrationChargeHiGainPix::fgAbsTimeLast     = 29.5;
// --------------------------------------------------------------------------
//
// Default Constructor. 
//
MHCalibrationChargeHiGainPix::MHCalibrationChargeHiGainPix(const char *name, const char *title)
    : fPix(NULL)
{

  fName  = name  ? name  : "MHCalibrationChargeHiGainPix";
  fTitle = title ? title : "Fill the FADC sums of the HiGainPix events and perform the fits";
  
  SetChargeNbins();
  SetChargeFirst();
  SetChargeLast();
  
  SetAbsTimeNbins();
  SetAbsTimeFirst();
  SetAbsTimeLast();

}


void MHCalibrationChargeHiGainPix::Init()
{

  fHGausHist.SetName("HCalibrationChargeHiGainPix");
  fHGausHist.SetTitle("Distribution of Summed Hi Gain FADC slices Pixel ");  
  fHGausHist.SetXTitle("Sum FADC Slices");
  fHGausHist.SetYTitle("Nr. of events");
  fHGausHist.SetBins(fChargeNbins,fChargeFirst,fChargeLast);
  //  fHGausHist.Sumw2();

  fHAbsTime.SetName("HAbsTimeHiGainPix");
  fHAbsTime.SetTitle("Distribution of Absolute Arrival Times Hi Gain Pixel ");  
  fHAbsTime.SetXTitle("Absolute Arrival Time [FADC slice nr]");
  fHAbsTime.SetYTitle("Nr. of events");
  fHAbsTime.SetBins(fAbsTimeNbins,fAbsTimeFirst,fAbsTimeLast);

}















