#ifndef MARS_MMcCalibrationUpdate
#define MARS_MMcCalibrationUpdate

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MCalibrationChargeCam;
class MPedPhotCam;
class MGeomCam;
class MMcFadcHeader;
class MExtractedSignalCam;

class MMcCalibrationUpdate : public MTask
{
private:
    Bool_t CheckRunType(MParList *pList) const;
    Int_t  PreProcess(MParList *pList);
    Int_t  Process();
    Bool_t ReInit(MParList *pList);

    MCalibrationChargeCam *fCalCam;
    MPedPhotCam           *fPedPhotCam;
    MGeomCam              *fGeom;
    MMcFadcHeader         *fHeaderFadc;
    MExtractedSignalCam   *fSignalCam;

    Float_t fADC2PhInner; // Conversion factor from ADC counts to photons
    Float_t fADC2PhOuter; // for inner and outer pixels.

    Bool_t  fFillCalibrationCam;

    Float_t fAmplitude;      // FADC parameters from camera simulation (see camera manual)
    Float_t fAmplitudeOuter; // to be read from the MMcFadcHeader.
    Float_t fConversionHiLo; // Ratio of high to low gain.


public:
    MMcCalibrationUpdate(const char *name=NULL, const char *title=NULL);

    ClassDef(MMcCalibrationUpdate, 0)   // Task which obtains, for MC files, the pedestal mean and rms, and the calibration factor from ADC counts to photons. 
};

#endif






