#ifndef MARS_MHCalibrationChargeCam
#define MARS_MHCalibrationChargeCam

#ifndef ROOT_TObjArray
#include <TObjArray.h>
#endif

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

class MRawEvtData;
class MCalibrationChargeCam;
class MHCalibrationChargeHiGainPix;
class MHCalibrationChargeLoGainPix;
class MHCalibrationChargeCam : public MH, public MCamEvent
{
private:

  static const Float_t fgNumHiGainSaturationLimit; // The default number of fNumHiGainSaturationLimit
  static const Float_t fgNumLoGainSaturationLimit; // The default number of fNumLoGainSaturationLimit

  Float_t fNumHiGainSaturationLimit;      // The rel. number of saturated higain FADC slices in the whole run upon which the pixel is called saturated
  Float_t fNumLoGainSaturationLimit;      // The rel. number of saturated logain FADC slices in the whole run upon which the pixel is called saturated
  
  TObjArray *fHiGainArray;                //-> Array of MHCalibrationChargePix with hists
  TObjArray *fLoGainArray;                //-> Array of MHCalibrationChargePix with hists
  
  MCalibrationChargeCam  *fCam;           //!  Class holding the results
  MRawEvtData            *fRawEvt;        //!  Raw event data (time slices)


public:

  MHCalibrationChargeCam(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationChargeCam();

  void SetNumHiGainSaturationLimit( const Float_t lim=fgNumHiGainSaturationLimit) { fNumHiGainSaturationLimit = lim; }
  void SetNumLoGainSaturationLimit( const Float_t lim=fgNumLoGainSaturationLimit) { fNumLoGainSaturationLimit = lim; }

  Float_t GetNumHiGainSaturationLimit()                             const  { return fNumHiGainSaturationLimit; }
  Float_t GetNumLoGainSaturationLimit()                             const  { return fNumLoGainSaturationLimit; }

  
  MHCalibrationChargeHiGainPix &operator[](UInt_t i);
  const MHCalibrationChargeHiGainPix &operator[](UInt_t i) const;

  MHCalibrationChargeLoGainPix &operator()(UInt_t i);
  const MHCalibrationChargeLoGainPix &operator()(UInt_t i) const;

  Bool_t SetupFill(const MParList *pList);
  Bool_t ReInit   (      MParList *pList);
  Bool_t Fill     (const MParContainer *par, const Stat_t w=1);
  Bool_t Finalize ( );
  
  TObject *Clone(const char *) const;

  Bool_t GetPixelContent ( Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
  void   DrawPixelContent( Int_t num )  const;    

  ClassDef(MHCalibrationChargeCam, 1)	// Container for calibration information of the camera
};

#endif









