#ifndef MARS_MRawFileRead
#define MARS_MRawFileRead

#ifndef MARS_MRawRead
#include "MRawRead.h"
#endif

class MRawFileRead : public MRawRead
{
private:
    TString   fFileName;
    ifstream *fIn;        //! buffered input stream (file to read from)

    Int_t PreProcess(MParList *pList);
    Int_t Process();
    Int_t PostProcess();

public:
    MRawFileRead(const char *filename, const char *name=NULL, const char *title=NULL);
    ~MRawFileRead();

    const TString &GetFileName() const { return fFileName; }

    ClassDef(MRawFileRead, 0)	// Task to read the raw data binary file
};

#endif
