/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2002
!
!
\* ======================================================================== */

void dohtml()
{
    //
    //  don't forget that the shared object must have been loaded
    //

    //
    // Do not print 'Info' messages from the root system such like
    // TCanvas::Print
    //
    gErrorIgnoreLevel=kWarning;

    //
    //   create the html document class
    //
    THtml html;

    TString sourcedir;
    sourcedir += "manalysis:";
    sourcedir += "mastro:";
    sourcedir += "mbase:";
    sourcedir += "mcamera:";
    sourcedir += "mcalib:";
    sourcedir += "mdata:";
    sourcedir += "mfbase:";
    sourcedir += "mfileio:";
    sourcedir += "mfilter:";
    sourcedir += "mgeom:";
    sourcedir += "mgui:";
    sourcedir += "mhbase:";
    sourcedir += "mhist:";
    sourcedir += "mhistmc:";
    sourcedir += "mimage:";
    sourcedir += "mmain:";
    sourcedir += "mmc:";
    sourcedir += "mmontecarlo:";
    sourcedir += "mpointing:";
    sourcedir += "mranforest:";
    sourcedir += "mraw:";
    sourcedir += "mreflector:";
    sourcedir += "mreport:";
    sourcedir += "msignal:";
    sourcedir += "mtools:";
    sourcedir += ".:";

    html.SetSourceDir(sourcedir);
    html.SetOutputDir("htmldoc");

    html.MakeAll(kTRUE);

    html.SetSourceDir("macros");
    html.Convert("merpp.C",         "MARS - Merging and Preprocessing");
    html.Convert("readraw.C",       "MARS - How To Read A Raw");
    html.Convert("rootlogon.C",     "MARS - rootlogon.C");
    html.Convert("readCT1.C",       "MARS - Read and display CT1 Events");
    html.Convert("readMagic.C",     "MARS - Read and display Magic Events");
    html.Convert("CT1Hillas.C",     "MARS - Calculate CT1 Hillas");
    html.Convert("MagicHillas.C",   "MARS - Calculate Magic Hillas");
    html.Convert("collarea.C",      "MARS - Calculate Collection Area from a MC root file");
    html.Convert("threshold.C",     "MARS - Calculate Energy Threshold from a MC root file");
    html.Convert("trigrate.C",      "MARS - Calculate Trigger Rate from a MC root file");
    html.Convert("star.C",          "MARS - (St)andard (A)nalysis and (R)econstruction");
    html.Convert("starplot.C",      "MARS - Plot parameters from file created with star.C");
    html.Convert("comprob.C",       "MARS - Calculation of composite probabilities for G/H-Seperation");
    html.Convert("multidimdist.C",  "MARS - Calculation of multidimensional distances for G/H-Seperation");
    html.Convert("multidimdist2.C", "MARS - Calculation of multidimensional distances for G/H-Seperation");
    html.Convert("estimate.C",      "MARS - Shows results from the energy estimation");
    html.Convert("estfit.C",        "MARS - Fits the coefficients of the energy estimator MEnergyEstParam");
    html.Convert("plot.C",          "MARS - Plots 1D mars histogram");
    html.Convert("plot2.C",         "MARS - Plots a 2D mars histogram");
    html.Convert("starplot.C",      "MARS - Plots data from a STAR-file into a mars histogram");
    html.Convert("testenv.C",       "MARS - Example to use TEnv and Mars Eventloops");
    html.Convert("triglvl2.C",      "MARS - Example to use MMcTriggerLvl2 class, using filters and creating histograms");
    html.Convert("status.C",        "MARS - Example to use the online display");
    html.Convert("calibration.C",   "MARS - Example to use the calibration");
    html.Convert("pedvsevent.C",    "MARS - Example to use MPedCalcPedRun");
    html.Convert("pedphotcalc.C",   "MARS - Example to use MPedPhotCalc");
}
