#ifndef MARS_MAstro
#define MARS_MAstro

#ifndef ROOT_TROOT
#include <TROOT.h>
#endif

class MAstro
{
private:
    static Double_t Round(Double_t val);
    static Double_t Trunc(Double_t val);

public:
    static Double_t Hms2Sec(Int_t deg, UInt_t min, Double_t sec, char sgn='+');
    static Double_t Dms2Rad(Int_t deg, UInt_t min, Double_t sec, Char_t sgn='+');
    static Double_t Hms2Rad(Int_t hor, UInt_t min, Double_t sec, Char_t sgn='+');
    static Double_t Dms2Deg(Int_t deg, UInt_t min, Double_t sec, Char_t sgn='+');
    static Double_t Hms2Deg(Int_t hor, UInt_t min, Double_t sec, Char_t sgn='+');
    static Double_t Dms2Hor(Int_t deg, UInt_t min, Double_t sec, Char_t sgn='+');
    static Double_t Hms2Hor(Int_t hor, UInt_t min, Double_t sec, Char_t sgn='+');

    static void Day2Hms(Double_t rad, Char_t &sgn, UShort_t &deg, UShort_t &min, UShort_t &sec);
    static void Rad2Dms(Double_t rad, Char_t &sgn, UShort_t &deg, UShort_t &min, UShort_t &sec);
    static void Rad2Hms(Double_t rad, Char_t &sgn, UShort_t &deg, UShort_t &min, UShort_t &sec);
    static void Deg2Dms(Double_t rad, Char_t &sgn, UShort_t &deg, UShort_t &min, UShort_t &sec);
    static void Deg2Hms(Double_t rad, Char_t &sgn, UShort_t &deg, UShort_t &min, UShort_t &sec);
    static void Hor2Dms(Double_t rad, Char_t &sgn, UShort_t &deg, UShort_t &min, UShort_t &sec);
    static void Hor2Hms(Double_t rad, Char_t &sgn, UShort_t &deg, UShort_t &min, UShort_t &sec);

    static void Day2Hm(Double_t rad, Char_t &sgn, UShort_t &deg, Double_t &min);
    static void Rad2Dm(Double_t rad, Char_t &sgn, UShort_t &deg, Double_t &min);
    static void Rad2Hm(Double_t rad, Char_t &sgn, UShort_t &deg, Double_t &min);
    static void Deg2Dm(Double_t rad, Char_t &sgn, UShort_t &deg, Double_t &min);
    static void Deg2Hm(Double_t rad, Char_t &sgn, UShort_t &deg, Double_t &min);
    static void Hor2Dm(Double_t rad, Char_t &sgn, UShort_t &deg, Double_t &min);
    static void Hor2Hm(Double_t rad, Char_t &sgn, UShort_t &deg, Double_t &min);

    static Bool_t String2Angle(TString &str, Double_t &ret);
    static Bool_t Coordinate2Angle(const TString &str, Double_t &ret);

    static Double_t AngularDistance(Double_t theta0, Double_t phi0, Double_t theta1, Double_t phi1);
 
    static void  Mjd2Ymd(UInt_t mjd, UShort_t &y, Byte_t &m, Byte_t &d);
    static Int_t Ymd2Mjd(UShort_t y, Byte_t m, Byte_t d);

    ClassDef(MAstro, 0)
};

#endif
