/***************************************************************************
                          amccommands.h  -  description
                             -------------------
    begin                : Sun Nov 24 2002
    copyright            : (C) 2002 by Martin Merck
    email                : merck@astro.uni-wuerzburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is part of the MAGIC control software for the AMC.       *
 *   The software is only intended for use in the MAGIC telescope project  *
 *   All rights remain with the author.					   *
 ***************************************************************************/

// Definitions of the individual commands of the AMC
// controler box.

#define IDS_COMMAND_BOX 					"B%02d\r"
#define IDS_COMMAND_UNSELECT_BOX			"U\r"
#define IDS_COMMAND_RESET					"R\r"
#define IDS_COMMAND_INFO					"G\r"
#define IDS_COMMAND_QUERY					"Q\r"
#define IDS_COMMAND_DRIVER					"D%d\r"
#define IDS_COMMAND_DRIVER_RESET			"DR\r"
#define IDS_COMMAND_KILL					"K\r"
#define IDS_COMMAND_CENTER					"C\r"
#define IDS_COMMAND_LASER_ON				"L+\r"
#define IDS_COMMAND_LASER_OFF				"L-\r"
#define IDS_COMMAND_POWER_ON				"P+\r"
#define IDS_COMMAND_POWER_OFF				"P-\r"
#define IDS_COMMAND_MOVE					"MX%dY%d\r"
#define IDS_COMMAND_PERIOD					"Nx%dY%dN%d\r"
#define IDS_COMMAND_FREQUENCY_READ			"FR\r"
#define IDS_COMMAND_FREQUENCY_WRITE			"FW%d\r"
#define IDS_COMMAND_WORKING_READ			"WR\r"
#define IDS_COMMAND_WORKING_WRITE			"WW%d\r"
#define IDS_COMMAND_HOLDING_READ			"HR\r"
#define IDS_COMMAND_HOLDING_WRITE			"HW%d\r"
#define IDS_COMMAND_TEMP_LOW_READ			"VRLT\r"
#define IDS_COMMAND_TEMP_LOW_WRITE			"VWLT%d\r"
#define IDS_COMMAND_TEMP_HIGH_READ			"VRHT\r"
#define IDS_COMMAND_TEMP_HIGH_WRITE			"VWHT%d\r"
#define IDS_COMMAND_HUMIDITY_LOW_READ		"VRLH\r"
#define IDS_COMMAND_HUMIDITY_LOW_WRITE		"VWLH%d\r"
#define IDS_COMMAND_HUMIDITY_HIGH_READ		"VRHH\r"
#define IDS_COMMAND_HUMIDITY_HIGH_WRITE		"VWHH%d\r"
#define IDS_COMMAND_I_POWER_LOW_READ		"VRLI\r"
#define IDS_COMMAND_I_POWER_LOW_WRITE		"VWLI%d\r"
#define IDS_COMMAND_I_POWER_HIGH_READ		"VRHI\r"
#define IDS_COMMAND_I_POWER_HIGHH_WRITE		"VWHI%d\r"
#define IDS_COMMAND_V_POWER_LOW_READ		"VRLV\r"
#define IDS_COMMAND_V_POWER_LOW_WRITE		"VWLV%d\r"
#define IDS_COMMAND_V_POWER_HIGH_READ		"VRHV\r"
#define IDS_COMMAND_V_POWER_HIGH_WRITE		"VWHV%d\r"
#define IDS_COMMAND_V_SECONDARY_LOW_READ	"VRLS\r"
#define IDS_COMMAND_V_SECONDARY_LOW_WRITE	"VWLS%d\r"
#define IDS_COMMAND_V_SECONDARY_HIGH_READ	"VRHS\r"
#define IDS_COMMAND_V_SECONDARY_HIGH_WRITE	"VWHS%d\r"
#define IDS_COMMAND_V_LOGICAL_LOW_READ		"VRLL\r"
#define IDS_COMMAND_V_LOGICAL_LOW_WRITE		"VWLL%d\r"
#define IDS_COMMAND_V_LOGICAL_HIGH_READ		"VRHL\r"
#define IDS_COMMAND_V_LOGICAL_HIGH_WRITE	"VWHL%d\r"
#define IDS_COMMAND_TUNE_READ_DIR_X			"TRDX\r"
#define IDS_COMMAND_TUNE_WRITE_DIR_X		"TWDX%X\r"
#define IDS_COMMAND_TUNE_READ_DIR_Y			"TRDY\r"
#define IDS_COMMAND_TUNE_WRITE_DIR_Y		"TWDY%X\r"
#define IDS_COMMAND_TUNE_READ_POS_LIMIT_X	"TRPX\r"
#define IDS_COMMAND_TUNE_WRITE_POS_LIMIT_X	"TWPX%X\r"
#define IDS_COMMAND_TUNE_READ_POS_LIMIT_Y	"TRPY\r"
#define IDS_COMMAND_TUNE_WRITE_POS_LIMIT_Y	"TWPY%X\r"
#define IDS_COMMAND_TUNE_READ_NEG_LIMIT_X	"TRNX\r"
#define IDS_COMMAND_TUNE_WRITE_NEG_LIMIT_X	"TWNX%X\r"
#define IDS_COMMAND_TUNE_READ_NEG_LIMIT_Y	"TRNY\r"
#define IDS_COMMAND_TUNE_WRITE_NEG_LIMIT_Y	"TWNY%X\r"
