#include <klocale.h>
/****************************************************************************
** Form implementation generated from reading ui file './videodisplaybase.ui'
**
** Created: Thu Jan 29 00:51:31 2004
**      by:  The User Interface Compiler (uic)
**
** WARNING! All changes made in this file will be lost!
****************************************************************************/
#include "videodisplaybase.h"

#include <qcheckbox.h>
#include <qframe.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlcdnumber.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qslider.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

/* 
 *  Constructs a VideoDisplayBase which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
VideoDisplayBase::VideoDisplayBase( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
    if ( !name )
	setName( "VideoDisplayBase" );
    resize( 911, 652 ); 
    setMaximumSize( QSize( 2000, 2000 ) );
    setCaption( i18n( "VideoDisplay" ) );
    VideoDisplayBaseLayout = new QGridLayout( this ); 
    VideoDisplayBaseLayout->setSpacing( 6 );
    VideoDisplayBaseLayout->setMargin( 11 );

    Adjustment_Info = new QGroupBox( this, "Adjustment_Info" );
    Adjustment_Info->setTitle( i18n( "Adjustment" ) );
    Adjustment_Info->setColumnLayout(0, Qt::Vertical );
    Adjustment_Info->layout()->setSpacing( 0 );
    Adjustment_Info->layout()->setMargin( 0 );
    Adjustment_InfoLayout = new QGridLayout( Adjustment_Info->layout() );
    Adjustment_InfoLayout->setAlignment( Qt::AlignTop );
    Adjustment_InfoLayout->setSpacing( 6 );
    Adjustment_InfoLayout->setMargin( 4 );

    Layout22 = new QHBoxLayout; 
    Layout22->setSpacing( 0 );
    Layout22->setMargin( 0 );

    Spot = new QGroupBox( Adjustment_Info, "Spot" );
    Spot->setTitle( i18n( "Spot" ) );
    Spot->setColumnLayout(0, Qt::Vertical );
    Spot->layout()->setSpacing( 0 );
    Spot->layout()->setMargin( 0 );
    SpotLayout = new QGridLayout( Spot->layout() );
    SpotLayout->setAlignment( Qt::AlignTop );
    SpotLayout->setSpacing( 6 );
    SpotLayout->setMargin( 11 );

    SpotYLabel = new QLabel( Spot, "SpotYLabel" );
    SpotYLabel->setText( i18n( "X:" ) );

    SpotLayout->addWidget( SpotYLabel, 0, 0 );

    SpotXLabel = new QLabel( Spot, "SpotXLabel" );
    SpotXLabel->setText( i18n( "Y:" ) );

    SpotLayout->addWidget( SpotXLabel, 1, 0 );

    SpotY = new QLineEdit( Spot, "SpotY" );
    SpotY->setEnabled( FALSE );
    SpotY->setMinimumSize( QSize( 30, 0 ) );
    SpotY->setMaxLength( 4 );

    SpotLayout->addWidget( SpotY, 1, 1 );

    SpotX = new QLineEdit( Spot, "SpotX" );
    SpotX->setEnabled( FALSE );
    SpotX->setMinimumSize( QSize( 30, 0 ) );
    SpotX->setMaxLength( 4 );

    SpotLayout->addWidget( SpotX, 0, 1 );
    Layout22->addWidget( Spot );

    ReferenceGroup = new QGroupBox( Adjustment_Info, "ReferenceGroup" );
    ReferenceGroup->setTitle( i18n( "Ref." ) );
    ReferenceGroup->setColumnLayout(0, Qt::Vertical );
    ReferenceGroup->layout()->setSpacing( 0 );
    ReferenceGroup->layout()->setMargin( 0 );
    ReferenceGroupLayout = new QGridLayout( ReferenceGroup->layout() );
    ReferenceGroupLayout->setAlignment( Qt::AlignTop );
    ReferenceGroupLayout->setSpacing( 6 );
    ReferenceGroupLayout->setMargin( 11 );

    RefXLabel = new QLabel( ReferenceGroup, "RefXLabel" );
    RefXLabel->setText( i18n( "X:" ) );

    ReferenceGroupLayout->addWidget( RefXLabel, 0, 0 );

    RefYLabel = new QLabel( ReferenceGroup, "RefYLabel" );
    RefYLabel->setText( i18n( "Y:" ) );

    ReferenceGroupLayout->addWidget( RefYLabel, 1, 0 );

    RefX = new QLineEdit( ReferenceGroup, "RefX" );
    RefX->setEnabled( FALSE );
    RefX->setMinimumSize( QSize( 30, 0 ) );
    RefX->setText( QString::null );
    RefX->setMaxLength( 4 );

    ReferenceGroupLayout->addWidget( RefX, 0, 1 );

    RefY = new QLineEdit( ReferenceGroup, "RefY" );
    RefY->setEnabled( FALSE );
    RefY->setMinimumSize( QSize( 30, 0 ) );
    RefY->setMaxLength( 4 );

    ReferenceGroupLayout->addWidget( RefY, 1, 1 );
    Layout22->addWidget( ReferenceGroup );

    GlobalRefGroup = new QGroupBox( Adjustment_Info, "GlobalRefGroup" );
    GlobalRefGroup->setTitle( i18n( "Global" ) );
    GlobalRefGroup->setColumnLayout(0, Qt::Vertical );
    GlobalRefGroup->layout()->setSpacing( 0 );
    GlobalRefGroup->layout()->setMargin( 0 );
    GlobalRefGroupLayout = new QGridLayout( GlobalRefGroup->layout() );
    GlobalRefGroupLayout->setAlignment( Qt::AlignTop );
    GlobalRefGroupLayout->setSpacing( 6 );
    GlobalRefGroupLayout->setMargin( 11 );

    GRefXLabel = new QLabel( GlobalRefGroup, "GRefXLabel" );
    GRefXLabel->setText( i18n( "X:" ) );

    GlobalRefGroupLayout->addWidget( GRefXLabel, 0, 0 );

    GRefX = new QLineEdit( GlobalRefGroup, "GRefX" );
    GRefX->setEnabled( FALSE );
    GRefX->setMinimumSize( QSize( 30, 0 ) );
    GRefX->setMaxLength( 3 );

    GlobalRefGroupLayout->addWidget( GRefX, 0, 1 );

    GRefYLabel = new QLabel( GlobalRefGroup, "GRefYLabel" );
    GRefYLabel->setText( i18n( "Y:" ) );

    GlobalRefGroupLayout->addWidget( GRefYLabel, 1, 0 );

    GRefY = new QLineEdit( GlobalRefGroup, "GRefY" );
    GRefY->setEnabled( FALSE );
    GRefY->setMinimumSize( QSize( 30, 0 ) );
    GRefY->setMaxLength( 3 );

    GlobalRefGroupLayout->addWidget( GRefY, 1, 1 );
    Layout22->addWidget( GlobalRefGroup );

    Adjustment_InfoLayout->addLayout( Layout22, 0, 0 );

    Layout7 = new QGridLayout; 
    Layout7->setSpacing( 6 );
    Layout7->setMargin( 0 );

    SaveRefButton = new QPushButton( Adjustment_Info, "SaveRefButton" );
    SaveRefButton->setText( i18n( "Save as Ref." ) );

    Layout7->addWidget( SaveRefButton, 0, 0 );

    AdjustButton = new QPushButton( Adjustment_Info, "AdjustButton" );
    AdjustButton->setEnabled( TRUE );
    AdjustButton->setText( i18n( "Adjust to Ref." ) );

    Layout7->addWidget( AdjustButton, 1, 0 );

    SaveGRefButton = new QPushButton( Adjustment_Info, "SaveGRefButton" );
    SaveGRefButton->setText( i18n( "Save as Global" ) );

    Layout7->addWidget( SaveGRefButton, 0, 1 );

    GAdjustButton = new QPushButton( Adjustment_Info, "GAdjustButton" );
    GAdjustButton->setEnabled( TRUE );
    GAdjustButton->setText( i18n( "Adjust to Global" ) );

    Layout7->addWidget( GAdjustButton, 1, 1 );

    Adjustment_InfoLayout->addLayout( Layout7, 1, 0 );

    VideoDisplayBaseLayout->addWidget( Adjustment_Info, 1, 1 );

    m_videoFrame = new QFrame( this, "m_videoFrame" );
    m_videoFrame->setMinimumSize( QSize( 640, 480 ) );
    m_videoFrame->setMaximumSize( QSize( 768, 576 ) );
    m_videoFrame->setFrameShape( QFrame::NoFrame );
    m_videoFrame->setFrameShadow( QFrame::Raised );

    VideoDisplayBaseLayout->addWidget( m_videoFrame, 0, 0 );

    Layout13 = new QVBoxLayout; 
    Layout13->setSpacing( 6 );
    Layout13->setMargin( 0 );

    Layout11 = new QHBoxLayout; 
    Layout11->setSpacing( 6 );
    Layout11->setMargin( 0 );

    Panel_Info = new QGroupBox( this, "Panel_Info" );
    Panel_Info->setTitle( i18n( "Panel" ) );
    Panel_Info->setColumnLayout(0, Qt::Vertical );
    Panel_Info->layout()->setSpacing( 0 );
    Panel_Info->layout()->setMargin( 0 );
    Panel_InfoLayout = new QHBoxLayout( Panel_Info->layout() );
    Panel_InfoLayout->setAlignment( Qt::AlignTop );
    Panel_InfoLayout->setSpacing( 6 );
    Panel_InfoLayout->setMargin( 11 );

    Device_Label = new QLabel( Panel_Info, "Device_Label" );
    Device_Label->setText( i18n( "Device: -" ) );
    Panel_InfoLayout->addWidget( Device_Label );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Panel_InfoLayout->addItem( spacer );

    Box_Label = new QLabel( Panel_Info, "Box_Label" );
    Box_Label->setText( i18n( "Box: --" ) );
    Panel_InfoLayout->addWidget( Box_Label );
    QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Panel_InfoLayout->addItem( spacer_2 );

    Driver_Label = new QLabel( Panel_Info, "Driver_Label" );
    Driver_Label->setText( i18n( "Driver: -" ) );
    Panel_InfoLayout->addWidget( Driver_Label );
    Layout11->addWidget( Panel_Info );
    QSpacerItem* spacer_3 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout11->addItem( spacer_3 );

    SpotFindingBox = new QGroupBox( this, "SpotFindingBox" );
    SpotFindingBox->setTitle( i18n( "Spot finding" ) );
    SpotFindingBox->setColumnLayout(0, Qt::Vertical );
    SpotFindingBox->layout()->setSpacing( 0 );
    SpotFindingBox->layout()->setMargin( 0 );
    SpotFindingBoxLayout = new QHBoxLayout( SpotFindingBox->layout() );
    SpotFindingBoxLayout->setAlignment( Qt::AlignTop );
    SpotFindingBoxLayout->setSpacing( 6 );
    SpotFindingBoxLayout->setMargin( 11 );

    ThresholdValLabel = new QLabel( SpotFindingBox, "ThresholdValLabel" );
    ThresholdValLabel->setText( i18n( "Threshold" ) );
    SpotFindingBoxLayout->addWidget( ThresholdValLabel );

    thresholdSlider = new QSlider( SpotFindingBox, "thresholdSlider" );
    thresholdSlider->setMinValue( 2 );
    thresholdSlider->setOrientation( QSlider::Horizontal );
    SpotFindingBoxLayout->addWidget( thresholdSlider );

    thresholdLCD = new QLCDNumber( SpotFindingBox, "thresholdLCD" );
    thresholdLCD->setNumDigits( 2 );
    SpotFindingBoxLayout->addWidget( thresholdLCD );
    Layout11->addWidget( SpotFindingBox );
    Layout13->addLayout( Layout11 );
    QSpacerItem* spacer_4 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    Layout13->addItem( spacer_4 );

    Layout12 = new QGridLayout; 
    Layout12->setSpacing( 6 );
    Layout12->setMargin( 0 );

    ImageControlBox = new QGroupBox( this, "ImageControlBox" );
    ImageControlBox->setTitle( i18n( "ImageControl" ) );
    ImageControlBox->setColumnLayout(0, Qt::Vertical );
    ImageControlBox->layout()->setSpacing( 0 );
    ImageControlBox->layout()->setMargin( 0 );
    ImageControlBoxLayout = new QGridLayout( ImageControlBox->layout() );
    ImageControlBoxLayout->setAlignment( Qt::AlignTop );
    ImageControlBoxLayout->setSpacing( 6 );
    ImageControlBoxLayout->setMargin( 11 );

    darksBox = new QCheckBox( ImageControlBox, "darksBox" );
    darksBox->setText( i18n( "Substract darks" ) );

    ImageControlBoxLayout->addWidget( darksBox, 1, 0 );

    Clear_Darks_Button = new QPushButton( ImageControlBox, "Clear_Darks_Button" );
    Clear_Darks_Button->setText( i18n( "Clear Darks" ) );

    ImageControlBoxLayout->addMultiCellWidget( Clear_Darks_Button, 1, 1, 3, 4 );

    MaxValLabel = new QLabel( ImageControlBox, "MaxValLabel" );
    MaxValLabel->setText( i18n( "Max. Val." ) );

    ImageControlBoxLayout->addWidget( MaxValLabel, 0, 1 );
    QSpacerItem* spacer_5 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    ImageControlBoxLayout->addItem( spacer_5, 1, 5 );

    Contrast = new QSlider( ImageControlBox, "Contrast" );
    Contrast->setMaxValue( 127 );
    Contrast->setValue( 64 );
    Contrast->setOrientation( QSlider::Horizontal );

    ImageControlBoxLayout->addWidget( Contrast, 1, 7 );

    Brightness = new QSlider( ImageControlBox, "Brightness" );
    Brightness->setMaxValue( 255 );
    Brightness->setValue( 128 );
    Brightness->setOrientation( QSlider::Horizontal );

    ImageControlBoxLayout->addWidget( Brightness, 0, 7 );

    BrightnessLabel = new QLabel( ImageControlBox, "BrightnessLabel" );
    BrightnessLabel->setText( i18n( "Brightness:" ) );

    ImageControlBoxLayout->addWidget( BrightnessLabel, 0, 6 );

    Contrast_LCD = new QLCDNumber( ImageControlBox, "Contrast_LCD" );
    Contrast_LCD->setNumDigits( 3 );

    ImageControlBoxLayout->addWidget( Contrast_LCD, 1, 8 );

    Brightness_LCD = new QLCDNumber( ImageControlBox, "Brightness_LCD" );
    Brightness_LCD->setNumDigits( 3 );

    ImageControlBoxLayout->addWidget( Brightness_LCD, 0, 8 );

    Take_Dark_Button = new QPushButton( ImageControlBox, "Take_Dark_Button" );
    Take_Dark_Button->setText( i18n( "Take Dark" ) );

    ImageControlBoxLayout->addMultiCellWidget( Take_Dark_Button, 1, 1, 1, 2 );

    scaleBox = new QCheckBox( ImageControlBox, "scaleBox" );
    scaleBox->setText( i18n( "Rescale image" ) );

    ImageControlBoxLayout->addWidget( scaleBox, 0, 0 );
    QSpacerItem* spacer_6 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    ImageControlBoxLayout->addItem( spacer_6, 0, 5 );

    ContrastLabel = new QLabel( ImageControlBox, "ContrastLabel" );
    ContrastLabel->setText( i18n( "Contrast:" ) );

    ImageControlBoxLayout->addWidget( ContrastLabel, 1, 6 );

    scaleValLCD = new QLCDNumber( ImageControlBox, "scaleValLCD" );
    scaleValLCD->setNumDigits( 3 );

    ImageControlBoxLayout->addWidget( scaleValLCD, 0, 4 );

    scaleValSlider = new QSlider( ImageControlBox, "scaleValSlider" );
    scaleValSlider->setMinValue( 10 );
    scaleValSlider->setMaxValue( 250 );
    scaleValSlider->setOrientation( QSlider::Horizontal );

    ImageControlBoxLayout->addMultiCellWidget( scaleValSlider, 0, 0, 2, 3 );

    Layout12->addMultiCellWidget( ImageControlBox, 0, 1, 0, 0 );

    m_exitButton = new QPushButton( this, "m_exitButton" );
    m_exitButton->setText( i18n( "Exit" ) );
    m_exitButton->setDefault( TRUE );

    Layout12->addWidget( m_exitButton, 1, 1 );

    StoreButton = new QPushButton( this, "StoreButton" );
    StoreButton->setText( i18n( "Store" ) );

    Layout12->addWidget( StoreButton, 0, 1 );
    Layout13->addLayout( Layout12 );

    VideoDisplayBaseLayout->addLayout( Layout13, 1, 0 );

    Layout8 = new QVBoxLayout; 
    Layout8->setSpacing( 6 );
    Layout8->setMargin( 0 );

    Grabber_Info = new QGroupBox( this, "Grabber_Info" );
    Grabber_Info->setTitle( i18n( "Frames" ) );
    Grabber_Info->setColumnLayout(0, Qt::Vertical );
    Grabber_Info->layout()->setSpacing( 0 );
    Grabber_Info->layout()->setMargin( 0 );
    Grabber_InfoLayout = new QHBoxLayout( Grabber_Info->layout() );
    Grabber_InfoLayout->setAlignment( Qt::AlignTop );
    Grabber_InfoLayout->setSpacing( 6 );
    Grabber_InfoLayout->setMargin( 11 );

    GrabbedLabel = new QLabel( Grabber_Info, "GrabbedLabel" );
    GrabbedLabel->setText( i18n( "Grabbed" ) );
    Grabber_InfoLayout->addWidget( GrabbedLabel );

    GrabbedLCD = new QLCDNumber( Grabber_Info, "GrabbedLCD" );
    GrabbedLCD->setNumDigits( 2 );
    Grabber_InfoLayout->addWidget( GrabbedLCD );
    QSpacerItem* spacer_7 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Grabber_InfoLayout->addItem( spacer_7 );

    ProcessedLabel = new QLabel( Grabber_Info, "ProcessedLabel" );
    ProcessedLabel->setText( i18n( "Processed" ) );
    Grabber_InfoLayout->addWidget( ProcessedLabel );

    ProcessedLCD = new QLCDNumber( Grabber_Info, "ProcessedLCD" );
    ProcessedLCD->setNumDigits( 2 );
    Grabber_InfoLayout->addWidget( ProcessedLCD );
    Layout8->addWidget( Grabber_Info );

    Motors_Box = new QGroupBox( this, "Motors_Box" );
    Motors_Box->setTitle( i18n( "Motors" ) );
    Motors_Box->setColumnLayout(0, Qt::Vertical );
    Motors_Box->layout()->setSpacing( 0 );
    Motors_Box->layout()->setMargin( 0 );
    Motors_BoxLayout = new QVBoxLayout( Motors_Box->layout() );
    Motors_BoxLayout->setAlignment( Qt::AlignTop );
    Motors_BoxLayout->setSpacing( 6 );
    Motors_BoxLayout->setMargin( 11 );

    X_Mot_Box = new QGroupBox( Motors_Box, "X_Mot_Box" );
    QFont X_Mot_Box_font(  X_Mot_Box->font() );
    X_Mot_Box_font.setFamily( "adobe-helvetica" );
    X_Mot_Box->setFont( X_Mot_Box_font ); 
    X_Mot_Box->setTitle( i18n( "X=0" ) );
    X_Mot_Box->setColumnLayout(0, Qt::Vertical );
    X_Mot_Box->layout()->setSpacing( 0 );
    X_Mot_Box->layout()->setMargin( 0 );
    X_Mot_BoxLayout = new QGridLayout( X_Mot_Box->layout() );
    X_Mot_BoxLayout->setAlignment( Qt::AlignTop );
    X_Mot_BoxLayout->setSpacing( 0 );
    X_Mot_BoxLayout->setMargin( 11 );
    QSpacerItem* spacer_8 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    X_Mot_BoxLayout->addItem( spacer_8, 1, 1 );
    QSpacerItem* spacer_9 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    X_Mot_BoxLayout->addItem( spacer_9, 4, 1 );

    X_Go_Button = new QPushButton( X_Mot_Box, "X_Go_Button" );
    X_Go_Button->setEnabled( TRUE );
    X_Go_Button->setMinimumSize( QSize( 50, 0 ) );
    X_Go_Button->setText( i18n( "Go" ) );

    X_Mot_BoxLayout->addWidget( X_Go_Button, 2, 1 );

    X_Dec_10_Button = new QPushButton( X_Mot_Box, "X_Dec_10_Button" );
    X_Dec_10_Button->setEnabled( TRUE );
    X_Dec_10_Button->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)0, X_Dec_10_Button->sizePolicy().hasHeightForWidth() ) );
    X_Dec_10_Button->setMinimumSize( QSize( 0, 0 ) );
    X_Dec_10_Button->setText( i18n( "-10" ) );

    X_Mot_BoxLayout->addWidget( X_Dec_10_Button, 3, 0 );

    X_Dec_100_Button = new QPushButton( X_Mot_Box, "X_Dec_100_Button" );
    X_Dec_100_Button->setEnabled( TRUE );
    X_Dec_100_Button->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)0, X_Dec_100_Button->sizePolicy().hasHeightForWidth() ) );
    X_Dec_100_Button->setMinimumSize( QSize( 0, 0 ) );
    X_Dec_100_Button->setText( i18n( "-100" ) );

    X_Mot_BoxLayout->addWidget( X_Dec_100_Button, 4, 0 );
    QSpacerItem* spacer_10 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    X_Mot_BoxLayout->addItem( spacer_10, 0, 1 );
    QSpacerItem* spacer_11 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    X_Mot_BoxLayout->addItem( spacer_11, 3, 1 );

    X_Inc_100_Button = new QPushButton( X_Mot_Box, "X_Inc_100_Button" );
    X_Inc_100_Button->setEnabled( TRUE );
    X_Inc_100_Button->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)0, X_Inc_100_Button->sizePolicy().hasHeightForWidth() ) );
    X_Inc_100_Button->setMinimumSize( QSize( 0, 0 ) );
    QFont X_Inc_100_Button_font(  X_Inc_100_Button->font() );
    X_Inc_100_Button->setFont( X_Inc_100_Button_font ); 
    X_Inc_100_Button->setText( i18n( "+100" ) );

    X_Mot_BoxLayout->addWidget( X_Inc_100_Button, 0, 0 );

    X_Goto_Value = new QLineEdit( X_Mot_Box, "X_Goto_Value" );
    X_Goto_Value->setEnabled( TRUE );
    X_Goto_Value->setMinimumSize( QSize( 50, 0 ) );
    X_Goto_Value->setText( i18n( "0" ) );

    X_Mot_BoxLayout->addWidget( X_Goto_Value, 2, 0 );

    X_Inc_10_Button = new QPushButton( X_Mot_Box, "X_Inc_10_Button" );
    X_Inc_10_Button->setEnabled( TRUE );
    X_Inc_10_Button->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)0, X_Inc_10_Button->sizePolicy().hasHeightForWidth() ) );
    X_Inc_10_Button->setMinimumSize( QSize( 0, 0 ) );
    X_Inc_10_Button->setText( i18n( "+10" ) );

    X_Mot_BoxLayout->addWidget( X_Inc_10_Button, 1, 0 );
    Motors_BoxLayout->addWidget( X_Mot_Box );

    Y_Mot_Box = new QGroupBox( Motors_Box, "Y_Mot_Box" );
    QFont Y_Mot_Box_font(  Y_Mot_Box->font() );
    Y_Mot_Box_font.setFamily( "adobe-helvetica" );
    Y_Mot_Box->setFont( Y_Mot_Box_font ); 
    Y_Mot_Box->setTitle( i18n( "Y=0" ) );
    Y_Mot_Box->setColumnLayout(0, Qt::Vertical );
    Y_Mot_Box->layout()->setSpacing( 0 );
    Y_Mot_Box->layout()->setMargin( 0 );
    Y_Mot_BoxLayout = new QGridLayout( Y_Mot_Box->layout() );
    Y_Mot_BoxLayout->setAlignment( Qt::AlignTop );
    Y_Mot_BoxLayout->setSpacing( 0 );
    Y_Mot_BoxLayout->setMargin( 11 );

    Y_Dec_100_Button = new QPushButton( Y_Mot_Box, "Y_Dec_100_Button" );
    Y_Dec_100_Button->setEnabled( TRUE );
    Y_Dec_100_Button->setText( i18n( "-100" ) );

    Y_Mot_BoxLayout->addWidget( Y_Dec_100_Button, 4, 0 );

    Y_Dec_10_Button = new QPushButton( Y_Mot_Box, "Y_Dec_10_Button" );
    Y_Dec_10_Button->setEnabled( TRUE );
    Y_Dec_10_Button->setText( i18n( "-10" ) );

    Y_Mot_BoxLayout->addWidget( Y_Dec_10_Button, 3, 0 );

    Y_Inc_100_Button = new QPushButton( Y_Mot_Box, "Y_Inc_100_Button" );
    Y_Inc_100_Button->setEnabled( TRUE );
    Y_Inc_100_Button->setText( i18n( "+100" ) );

    Y_Mot_BoxLayout->addWidget( Y_Inc_100_Button, 0, 0 );

    Y_Inc_10_Button = new QPushButton( Y_Mot_Box, "Y_Inc_10_Button" );
    Y_Inc_10_Button->setEnabled( TRUE );
    Y_Inc_10_Button->setText( i18n( "+10" ) );

    Y_Mot_BoxLayout->addWidget( Y_Inc_10_Button, 1, 0 );
    QSpacerItem* spacer_12 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Y_Mot_BoxLayout->addItem( spacer_12, 0, 1 );
    QSpacerItem* spacer_13 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Y_Mot_BoxLayout->addItem( spacer_13, 3, 1 );
    QSpacerItem* spacer_14 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Y_Mot_BoxLayout->addItem( spacer_14, 4, 1 );

    Y_Goto_Value = new QLineEdit( Y_Mot_Box, "Y_Goto_Value" );
    Y_Goto_Value->setEnabled( TRUE );
    Y_Goto_Value->setMinimumSize( QSize( 50, 0 ) );
    Y_Goto_Value->setText( i18n( "0" ) );

    Y_Mot_BoxLayout->addWidget( Y_Goto_Value, 2, 0 );
    QSpacerItem* spacer_15 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Y_Mot_BoxLayout->addItem( spacer_15, 1, 1 );

    Y_Go_Button = new QPushButton( Y_Mot_Box, "Y_Go_Button" );
    Y_Go_Button->setEnabled( TRUE );
    Y_Go_Button->setMinimumSize( QSize( 50, 0 ) );
    Y_Go_Button->setText( i18n( "Go" ) );

    Y_Mot_BoxLayout->addWidget( Y_Go_Button, 2, 1 );
    Motors_BoxLayout->addWidget( Y_Mot_Box );

    Layout9 = new QHBoxLayout; 
    Layout9->setSpacing( 6 );
    Layout9->setMargin( 0 );

    FocusButton = new QPushButton( Motors_Box, "FocusButton" );
    FocusButton->setText( i18n( "Focus" ) );
    Layout9->addWidget( FocusButton );
    QSpacerItem* spacer_16 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout9->addItem( spacer_16 );

    DefocusButton = new QPushButton( Motors_Box, "DefocusButton" );
    DefocusButton->setText( i18n( "Defocus" ) );
    Layout9->addWidget( DefocusButton );
    Motors_BoxLayout->addLayout( Layout9 );

    Layout9_2 = new QHBoxLayout; 
    Layout9_2->setSpacing( 6 );
    Layout9_2->setMargin( 0 );

    Laser_Check = new QCheckBox( Motors_Box, "Laser_Check" );
    Laser_Check->setText( i18n( "Laser" ) );
    Layout9_2->addWidget( Laser_Check );
    QSpacerItem* spacer_17 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout9_2->addItem( spacer_17 );

    Center_Button = new QPushButton( Motors_Box, "Center_Button" );
    Center_Button->setEnabled( TRUE );
    Center_Button->setText( i18n( "Center" ) );
    Layout9_2->addWidget( Center_Button );
    Motors_BoxLayout->addLayout( Layout9_2 );

    Layout10 = new QHBoxLayout; 
    Layout10->setSpacing( 6 );
    Layout10->setMargin( 0 );

    Calibrate_Button = new QPushButton( Motors_Box, "Calibrate_Button" );
    Calibrate_Button->setText( i18n( "Calibrate" ) );
    Layout10->addWidget( Calibrate_Button );
    QSpacerItem* spacer_18 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout10->addItem( spacer_18 );

    DefocusAllButton = new QPushButton( Motors_Box, "DefocusAllButton" );
    DefocusAllButton->setEnabled( TRUE );
    DefocusAllButton->setText( i18n( "Defocus all" ) );
    Layout10->addWidget( DefocusAllButton );
    Motors_BoxLayout->addLayout( Layout10 );
    Layout8->addWidget( Motors_Box );

    VideoDisplayBaseLayout->addLayout( Layout8, 0, 1 );

    // signals and slots connections
    connect( m_exitButton, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( StoreButton, SIGNAL( clicked() ), this, SLOT( storeSlot() ) );
    connect( X_Inc_100_Button, SIGNAL( clicked() ), this, SLOT( incX100Slot() ) );
    connect( X_Inc_10_Button, SIGNAL( clicked() ), this, SLOT( incX10Slot() ) );
    connect( X_Dec_10_Button, SIGNAL( clicked() ), this, SLOT( decX10Slot() ) );
    connect( X_Dec_100_Button, SIGNAL( clicked() ), this, SLOT( decX100Slot() ) );
    connect( Y_Inc_100_Button, SIGNAL( clicked() ), this, SLOT( incY100Slot() ) );
    connect( Y_Inc_10_Button, SIGNAL( clicked() ), this, SLOT( incY10Slot() ) );
    connect( Y_Dec_10_Button, SIGNAL( clicked() ), this, SLOT( decY10Slot() ) );
    connect( Y_Dec_100_Button, SIGNAL( clicked() ), this, SLOT( decY100Slot() ) );
    connect( Laser_Check, SIGNAL( toggled(bool) ), this, SLOT( switchLaserSlot( bool ) ) );
    connect( X_Go_Button, SIGNAL( clicked() ), this, SLOT( goXSlot() ) );
    connect( Y_Go_Button, SIGNAL( clicked() ), this, SLOT( goYSlot() ) );
    connect( SaveRefButton, SIGNAL( clicked() ), this, SLOT( saveRefSlot() ) );
    connect( SaveGRefButton, SIGNAL( clicked() ), this, SLOT( saveGRefSlot() ) );
    connect( AdjustButton, SIGNAL( clicked() ), this, SLOT( adjustRefSlot() ) );
    connect( Center_Button, SIGNAL( clicked() ), this, SLOT( centerSlot() ) );
    connect( Brightness, SIGNAL( valueChanged(int) ), Brightness_LCD, SLOT( display(int) ) );
    connect( Contrast, SIGNAL( valueChanged(int) ), Contrast_LCD, SLOT( display(int) ) );
    connect( Take_Dark_Button, SIGNAL( clicked() ), this, SLOT( takeDarkSlot() ) );
    connect( Clear_Darks_Button, SIGNAL( clicked() ), this, SLOT( clearDarksSlot() ) );
    connect( scaleValSlider, SIGNAL( valueChanged(int) ), scaleValLCD, SLOT( display(int) ) );
    connect( thresholdSlider, SIGNAL( valueChanged(int) ), thresholdLCD, SLOT( display(int) ) );
    connect( Calibrate_Button, SIGNAL( clicked() ), this, SLOT( calibrateSlot() ) );
    connect( GAdjustButton, SIGNAL( clicked() ), this, SLOT( adjustGRefSlot() ) );
    connect( DefocusAllButton, SIGNAL( clicked() ), this, SLOT( defocusAllSlot() ) );
    connect( FocusButton, SIGNAL( clicked() ), this, SLOT( focusSlot() ) );
    connect( DefocusButton, SIGNAL( clicked() ), this, SLOT( defocusSlot() ) );
}

/*  
 *  Destroys the object and frees any allocated resources
 */
VideoDisplayBase::~VideoDisplayBase()
{
    // no need to delete child widgets, Qt does it all for us
}

/*  
 *  Main event handler. Reimplemented to handle application
 *  font changes
 */
bool VideoDisplayBase::event( QEvent* ev )
{
    bool ret = QDialog::event( ev ); 
    if ( ev->type() == QEvent::ApplicationFontChange ) {
	QFont X_Mot_Box_font(  X_Mot_Box->font() );
	X_Mot_Box_font.setFamily( "adobe-helvetica" );
	X_Mot_Box->setFont( X_Mot_Box_font ); 
	QFont X_Inc_100_Button_font(  X_Inc_100_Button->font() );
	X_Inc_100_Button->setFont( X_Inc_100_Button_font ); 
	QFont Y_Mot_Box_font(  Y_Mot_Box->font() );
	Y_Mot_Box_font.setFamily( "adobe-helvetica" );
	Y_Mot_Box->setFont( Y_Mot_Box_font ); 
    }
    return ret;
}

void VideoDisplayBase::adjustGRefSlot()
{
    qWarning( "VideoDisplayBase::adjustGRefSlot(): Not implemented yet!" );
}

void VideoDisplayBase::adjustRefSlot()
{
    qWarning( "VideoDisplayBase::adjustRefSlot(): Not implemented yet!" );
}

void VideoDisplayBase::calibrateSlot()
{
    qWarning( "VideoDisplayBase::calibrateSlot(): Not implemented yet!" );
}

void VideoDisplayBase::centerSlot()
{
    qWarning( "VideoDisplayBase::centerSlot(): Not implemented yet!" );
}

void VideoDisplayBase::clearDarksSlot()
{
    qWarning( "VideoDisplayBase::clearDarksSlot(): Not implemented yet!" );
}

void VideoDisplayBase::decX100Slot()
{
    qWarning( "VideoDisplayBase::decX100Slot(): Not implemented yet!" );
}

void VideoDisplayBase::decX10Slot()
{
    qWarning( "VideoDisplayBase::decX10Slot(): Not implemented yet!" );
}

void VideoDisplayBase::decY100Slot()
{
    qWarning( "VideoDisplayBase::decY100Slot(): Not implemented yet!" );
}

void VideoDisplayBase::decY10Slot()
{
    qWarning( "VideoDisplayBase::decY10Slot(): Not implemented yet!" );
}

void VideoDisplayBase::defocusAllSlot()
{
    qWarning( "VideoDisplayBase::defocusAllSlot(): Not implemented yet!" );
}

void VideoDisplayBase::defocusSlot()
{
    qWarning( "VideoDisplayBase::defocusSlot(): Not implemented yet!" );
}

void VideoDisplayBase::goXSlot()
{
    qWarning( "VideoDisplayBase::goXSlot(): Not implemented yet!" );
}

void VideoDisplayBase::goYSlot()
{
    qWarning( "VideoDisplayBase::goYSlot(): Not implemented yet!" );
}

void VideoDisplayBase::incX100Slot()
{
    qWarning( "VideoDisplayBase::incX100Slot(): Not implemented yet!" );
}

void VideoDisplayBase::incX10Slot()
{
    qWarning( "VideoDisplayBase::incX10Slot(): Not implemented yet!" );
}

void VideoDisplayBase::incY100Slot()
{
    qWarning( "VideoDisplayBase::incY100Slot(): Not implemented yet!" );
}

void VideoDisplayBase::incY10Slot()
{
    qWarning( "VideoDisplayBase::incY10Slot(): Not implemented yet!" );
}

void VideoDisplayBase::focusSlot()
{
    qWarning( "VideoDisplayBase::focusSlot(): Not implemented yet!" );
}

void VideoDisplayBase::saveGRefSlot()
{
    qWarning( "VideoDisplayBase::saveGRefSlot(): Not implemented yet!" );
}

void VideoDisplayBase::saveRefSlot()
{
    qWarning( "VideoDisplayBase::saveRefSlot(): Not implemented yet!" );
}

void VideoDisplayBase::storeSlot()
{
    qWarning( "VideoDisplayBase::storeSlot(): Not implemented yet!" );
}

void VideoDisplayBase::switchLaserSlot( bool )
{
    qWarning( "VideoDisplayBase::switchLaserSlot( bool ): Not implemented yet!" );
}

void VideoDisplayBase::takeDarkSlot()
{
    qWarning( "VideoDisplayBase::takeDarkSlot(): Not implemented yet!" );
}

#include "videodisplaybase.moc"
